package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.Component;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.ComponentKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for the components in the system.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * container components {
 *   list component {
 *     key name;
 *     leaf name {
 *       type leafref {
 *         path ../config/name;
 *       }
 *     }
 *     container config {
 *       uses platform-component-config;
 *     }
 *     container state {
 *       config false;
 *       uses platform-component-config;
 *       uses platform-component-state;
 *       uses platform-component-temp-state;
 *       uses platform-component-memory-state;
 *       uses platform-component-power-state;
 *     }
 *     uses platform-component-properties-top;
 *     uses platform-subcomponent-ref-top;
 *     uses platform-anchors-top;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ComponentsBuilder}.
 * @see ComponentsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Components
    extends
    ChildOf<PlatformComponentTop>,
    Augmentable<Components>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("components");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.Components> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.Components.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.@NonNull Components obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getComponent());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.@NonNull Components thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.Components other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.Components.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getComponent(), other.getComponent())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.@NonNull Components obj) {
        final var helper = MoreObjects.toStringHelper("Components");
        CodeHelpers.appendValue(helper, "component", obj.getComponent());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return component, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of components, keyed by component name.
     *     </code>
     * </pre>
     *
     * @return {@code Map<ComponentKey, Component>} component, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ComponentKey, Component> getComponent();
    
    /**
     * Return component, or an empty list if it is not present.
     *
     * @return {@code Map<ComponentKey, Component>} component, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ComponentKey, Component> nonnullComponent() {
        return CodeHelpers.nonnull(getComponent());
    }

}

