package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Class that builds {@link Memory} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Memory createMemory(int fooXyzzy, int barBaz) {
 *         return new MemoryBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Memory, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Memory
 *
 */
@Generated("mdsal-binding-generator")
public class MemoryBuilder {

    private Uint64 _available;
    private Uint64 _utilized;


    Map<Class<? extends Augmentation<Memory>>, Augmentation<Memory>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public MemoryBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Memory}.
     *
     * @param base Memory from which the builder should be initialized
     */
    public MemoryBuilder(Memory base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._available = base.getAvailable();
        this._utilized = base.getUtilized();
    }


    /**
     * Return current value associated with the property corresponding to {@link Memory#getAvailable()}.
     *
     * @return current value
     */
    public Uint64 getAvailable() {
        return _available;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Memory#getUtilized()}.
     *
     * @return current value
     */
    public Uint64 getUtilized() {
        return _utilized;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Memory>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Memory#getAvailable()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MemoryBuilder setAvailable(final Uint64 value) {
        this._available = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Memory#getUtilized()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MemoryBuilder setUtilized(final Uint64 value) {
        this._utilized = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MemoryBuilder addAugmentation(Augmentation<Memory> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MemoryBuilder removeAugmentation(Class<? extends Augmentation<Memory>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Memory} instance.
     *
     * @return A new {@link Memory} instance.
     */
    public @NonNull Memory build() {
        return new MemoryImpl(this);
    }

    private static final class MemoryImpl
        extends AbstractAugmentable<Memory>
        implements Memory {
    
        private final Uint64 _available;
        private final Uint64 _utilized;
    
        MemoryImpl(MemoryBuilder base) {
            super(base.augmentation);
            this._available = base.getAvailable();
            this._utilized = base.getUtilized();
        }
    
        @Override
        public Uint64 getAvailable() {
            return _available;
        }
        
        @Override
        public Uint64 getUtilized() {
            return _utilized;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Memory.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Memory.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Memory.bindingToString(this);
        }
    }
}
