package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum Transport implements Enumeration {
    /**
     * Transmission Control Protocol (TCP).
     */
    TCP(0, "TCP"),
    
    /**
     * Transport Layer Security (TLS).
     */
    TLS(1, "TLS")
    ;

    private final @NonNull String name;
    private final int value;

    private Transport(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding Transport item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable Transport forName(String name) {
        return switch (name) {
            case "TCP" -> TCP;
            case "TLS" -> TLS;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding Transport item, or {@code null} if no such item exists
     */
    public static @Nullable Transport forValue(int intValue) {
        return switch (intValue) {
            case 0 -> TCP;
            case 1 -> TLS;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding Transport item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull Transport ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding Transport item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull Transport ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
