package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum FailureMode implements Enumeration {
    /**
     * Packets and messages destined to the controllers are
     * dropped. Flow entries continue to expire according to
     * their timeouts.
     */
    SECURE(0, "SECURE"),
    
    /**
     * Processes all packets using the OFPP_NORMAL reserved
     * port. The switch acts as a legacy Ethernet switch or
     * router.
     */
    STANDALONE(1, "STANDALONE")
    ;

    private final @NonNull String name;
    private final int value;

    private FailureMode(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding FailureMode item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable FailureMode forName(String name) {
        return switch (name) {
            case "SECURE" -> SECURE;
            case "STANDALONE" -> STANDALONE;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding FailureMode item, or {@code null} if no such item exists
     */
    public static @Nullable FailureMode forValue(int intValue) {
        return switch (intValue) {
            case 0 -> SECURE;
            case 1 -> STANDALONE;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding FailureMode item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull FailureMode ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding FailureMode item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull FailureMode ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
