package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.Transport;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private IpAddress _address;
    private AuxiliaryId _auxId;
    private String _certificateId;
    private Boolean _connected;
    private PortNumber _port;
    private Uint8 _priority;
    private String _sourceInterface;
    private Transport _transport;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link OpenflowConnectionsConfig}.
     *
     * @param arg OpenflowConnectionsConfig from which the builder should be initialized
     */
    public StateBuilder(OpenflowConnectionsConfig arg) {
        this._auxId = arg.getAuxId();
        this._priority = arg.getPriority();
        this._address = arg.getAddress();
        this._port = arg.getPort();
        this._transport = arg.getTransport();
        this._certificateId = arg.getCertificateId();
        this._sourceInterface = arg.getSourceInterface();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link OpenflowConnectionsState}.
     *
     * @param arg OpenflowConnectionsState from which the builder should be initialized
     */
    public StateBuilder(OpenflowConnectionsState arg) {
        this._connected = arg.getConnected();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._address = base.getAddress();
        this._auxId = base.getAuxId();
        this._certificateId = base.getCertificateId();
        this._connected = base.getConnected();
        this._port = base.getPort();
        this._priority = base.getPriority();
        this._sourceInterface = base.getSourceInterface();
        this._transport = base.getTransport();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link OpenflowConnectionsState}</li>
     *   <li>{@link OpenflowConnectionsConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowConnectionsState castArg) {
            this._connected = castArg.getConnected();
            isValidArg = true;
        }
        if (arg instanceof OpenflowConnectionsConfig castArg) {
            this._auxId = castArg.getAuxId();
            this._priority = castArg.getPriority();
            this._address = castArg.getAddress();
            this._port = castArg.getPort();
            this._transport = castArg.getTransport();
            this._certificateId = castArg.getCertificateId();
            this._sourceInterface = castArg.getSourceInterface();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[OpenflowConnectionsState, OpenflowConnectionsConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getAddress()}.
     *
     * @return current value
     */
    public IpAddress getAddress() {
        return _address;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getAuxId()}.
     *
     * @return current value
     */
    public AuxiliaryId getAuxId() {
        return _auxId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getCertificateId()}.
     *
     * @return current value
     */
    public String getCertificateId() {
        return _certificateId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getConnected()}.
     *
     * @return current value
     */
    public Boolean getConnected() {
        return _connected;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getPort()}.
     *
     * @return current value
     */
    public PortNumber getPort() {
        return _port;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getPriority()}.
     *
     * @return current value
     */
    public Uint8 getPriority() {
        return _priority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getSourceInterface()}.
     *
     * @return current value
     */
    public String getSourceInterface() {
        return _sourceInterface;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getTransport()}.
     *
     * @return current value
     */
    public Transport getTransport() {
        return _transport;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAddress(final IpAddress value) {
        this._address = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getAuxId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAuxId(final AuxiliaryId value) {
        this._auxId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getCertificateId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setCertificateId(final String value) {
        this._certificateId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getConnected()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setConnected(final Boolean value) {
        this._connected = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getPort()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setPort(final PortNumber value) {
        this._port = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setPriority(final Uint8 value) {
        this._priority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getSourceInterface()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setSourceInterface(final String value) {
        this._sourceInterface = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getTransport()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setTransport(final Transport value) {
        this._transport = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final IpAddress _address;
        private final AuxiliaryId _auxId;
        private final String _certificateId;
        private final Boolean _connected;
        private final PortNumber _port;
        private final Uint8 _priority;
        private final String _sourceInterface;
        private final Transport _transport;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._auxId = base.getAuxId();
            this._certificateId = base.getCertificateId();
            this._connected = base.getConnected();
            this._port = base.getPort();
            this._priority = base.getPriority();
            this._sourceInterface = base.getSourceInterface();
            this._transport = base.getTransport();
        }
    
        @Override
        public IpAddress getAddress() {
            return _address;
        }
        
        @Override
        public AuxiliaryId getAuxId() {
            return _auxId;
        }
        
        @Override
        public String getCertificateId() {
            return _certificateId;
        }
        
        @Override
        public Boolean getConnected() {
            return _connected;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
        
        @Override
        public Uint8 getPriority() {
            return _priority;
        }
        
        @Override
        public String getSourceInterface() {
            return _sourceInterface;
        }
        
        @Override
        public Transport getTransport() {
            return _transport;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
