package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Connection} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Connection createConnection(int fooXyzzy, int barBaz) {
 *         return new ConnectionBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Connection, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Connection
 *
 */
@Generated("mdsal-binding-generator")
public class ConnectionBuilder {

    private AuxiliaryId _auxId;
    private Config _config;
    private State _state;
    private ConnectionKey key;


    Map<Class<? extends Augmentation<Connection>>, Augmentation<Connection>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConnectionBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Connection}.
     *
     * @param base Connection from which the builder should be initialized
     */
    public ConnectionBuilder(Connection base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._auxId = base.getAuxId();
        this._config = base.getConfig();
        this._state = base.getState();
    }


    /**
     * Return current value associated with the property corresponding to {@link Connection#key()}.
     *
     * @return current value
     */
    public ConnectionKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Connection#getAuxId()}.
     *
     * @return current value
     */
    public AuxiliaryId getAuxId() {
        return _auxId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Connection#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Connection#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Connection>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Connection#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public ConnectionBuilder withKey(final ConnectionKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Connection#getAuxId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConnectionBuilder setAuxId(final AuxiliaryId value) {
        this._auxId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Connection#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConnectionBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Connection#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConnectionBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConnectionBuilder addAugmentation(Augmentation<Connection> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConnectionBuilder removeAugmentation(Class<? extends Augmentation<Connection>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Connection} instance.
     *
     * @return A new {@link Connection} instance.
     */
    public @NonNull Connection build() {
        return new ConnectionImpl(this);
    }

    private static final class ConnectionImpl
        extends AbstractAugmentable<Connection>
        implements Connection {
    
        private final AuxiliaryId _auxId;
        private final Config _config;
        private final State _state;
        private final ConnectionKey key;
    
        ConnectionImpl(ConnectionBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ConnectionKey(base.getAuxId());
            }
            this._auxId = key.getAuxId();
            this._config = base.getConfig();
            this._state = base.getState();
        }
    
        @Override
        public ConnectionKey key() {
            return key;
        }
        
        @Override
        public AuxiliaryId getAuxId() {
            return _auxId;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Connection.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Connection.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Connection.bindingToString(this);
        }
    }
}
