package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines configuration and operational state data for licenses.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-license</b>
 * <pre>
 * module openconfig-license {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/license";
 *   prefix oc-license;
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   oc-ext:openconfig-version 0.2.0;
 *   revision 2020-04-22 {
 *   }
 *   revision 2020-01-07 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   grouping license-config {
 *     leaf license-id {
 *       type string;
 *     }
 *     leaf license-data {
 *       type union {
 *         type binary;
 *         type string;
 *       }
 *     }
 *     leaf active {
 *       type boolean;
 *       default false;
 *     }
 *   }
 *   grouping license-state {
 *     leaf description {
 *       type string;
 *     }
 *     leaf issue-date {
 *       type uint64;
 *     }
 *     leaf expiration-date {
 *       type uint64;
 *     }
 *     leaf in-use {
 *       type boolean;
 *     }
 *     leaf expired {
 *       type boolean;
 *     }
 *     leaf valid {
 *       type boolean;
 *     }
 *   }
 *   grouping licenses-top {
 *     container licenses {
 *       list license {
 *         key license-id;
 *         leaf license-id {
 *           type leafref {
 *             path ../config/license-id;
 *           }
 *         }
 *         container config {
 *           uses license-config;
 *         }
 *         container state {
 *           config false;
 *           uses license-config;
 *           uses license-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping license-top {
 *     container license {
 *       uses licenses-top;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigLicenseData
    extends
    DataRoot
{





}

