package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Operational state data (in addition to intended configuration) at the global 
 * level for this interface
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-interfaces</b>
 * <pre>
 * grouping interface-common-state {
 *   oc-ext:operational;
 *   leaf ifindex {
 *     type uint32;
 *     oc-ext:telemetry-on-change;
 *   }
 *   leaf admin-status {
 *     type enumeration {
 *       enum UP {
 *       }
 *       enum DOWN {
 *       }
 *       enum TESTING {
 *       }
 *     }
 *     oc-ext:telemetry-on-change;
 *   }
 *   leaf oper-status {
 *     type enumeration {
 *       enum UP {
 *         value 1;
 *       }
 *       enum DOWN {
 *         value 2;
 *       }
 *       enum TESTING {
 *         value 3;
 *       }
 *       enum UNKNOWN {
 *         value 4;
 *       }
 *       enum DORMANT {
 *         value 5;
 *       }
 *       enum NOT_PRESENT {
 *         value 6;
 *       }
 *       enum LOWER_LAYER_DOWN {
 *         value 7;
 *       }
 *     }
 *     oc-ext:telemetry-on-change;
 *   }
 *   leaf last-change {
 *     type oc-types:timeticks64;
 *     oc-ext:telemetry-on-change;
 *   }
 *   leaf logical {
 *     type boolean;
 *     oc-ext:telemetry-on-change;
 *   }
 *   leaf management {
 *     type boolean;
 *     oc-ext:telemetry-on-change;
 *   }
 *   leaf cpu {
 *     type boolean;
 *     oc-ext:telemetry-on-change;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface InterfaceCommonState
    extends
    DataObject
{


    @Generated("mdsal-binding-generator")
    public enum AdminStatus implements Enumeration {
        /**
         * Ready to pass packets.
         */
        UP(0, "UP"),
        
        /**
         * Not ready to pass packets and not in some test mode.
         */
        DOWN(1, "DOWN"),
        
        /**
         * In some test mode.
         */
        TESTING(2, "TESTING")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private AdminStatus(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding AdminStatus item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable AdminStatus forName(String name) {
            return switch (name) {
                case "UP" -> UP;
                case "DOWN" -> DOWN;
                case "TESTING" -> TESTING;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding AdminStatus item, or {@code null} if no such item exists
         */
        public static @Nullable AdminStatus forValue(int intValue) {
            return switch (intValue) {
                case 0 -> UP;
                case 1 -> DOWN;
                case 2 -> TESTING;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding AdminStatus item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull AdminStatus ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding AdminStatus item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull AdminStatus ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }
    
    @Generated("mdsal-binding-generator")
    public enum OperStatus implements Enumeration {
        /**
         * Ready to pass packets.
         */
        UP(1, "UP"),
        
        /**
         * The interface does not pass any packets.
         */
        DOWN(2, "DOWN"),
        
        /**
         * In some test mode.  No operational packets can
         * be passed.
         */
        TESTING(3, "TESTING"),
        
        /**
         * Status cannot be determined for some reason.
         */
        UNKNOWN(4, "UNKNOWN"),
        
        /**
         * Waiting for some external event.
         */
        DORMANT(5, "DORMANT"),
        
        /**
         * Some component (typically hardware) is missing.
         */
        NOTPRESENT(6, "NOT_PRESENT"),
        
        /**
         * Down due to state of lower-layer interface(s).
         */
        LOWERLAYERDOWN(7, "LOWER_LAYER_DOWN")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private OperStatus(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding OperStatus item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable OperStatus forName(String name) {
            return switch (name) {
                case "UP" -> UP;
                case "DOWN" -> DOWN;
                case "TESTING" -> TESTING;
                case "UNKNOWN" -> UNKNOWN;
                case "DORMANT" -> DORMANT;
                case "NOT_PRESENT" -> NOTPRESENT;
                case "LOWER_LAYER_DOWN" -> LOWERLAYERDOWN;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding OperStatus item, or {@code null} if no such item exists
         */
        public static @Nullable OperStatus forValue(int intValue) {
            return switch (intValue) {
                case 1 -> UP;
                case 2 -> DOWN;
                case 3 -> TESTING;
                case 4 -> UNKNOWN;
                case 5 -> DORMANT;
                case 6 -> NOTPRESENT;
                case 7 -> LOWERLAYERDOWN;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding OperStatus item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull OperStatus ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding OperStatus item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull OperStatus ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("interface-common-state");

    @Override
    Class<? extends InterfaceCommonState> implementedInterface();
    
    /**
     * Return ifindex, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         System assigned number for each interface. Corresponds to ifIndex object in SNMP
     *         Interface MIB
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} ifindex, or {@code null} if it is not present.
     *
     */
    Uint32 getIfindex();
    
    /**
     * Return ifindex, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         System assigned number for each interface. Corresponds to ifIndex object in SNMP
     *         Interface MIB
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} ifindex, guaranteed to be non-null.
     * @throws NoSuchElementException if ifindex is not present
     *
     */
    default @NonNull Uint32 requireIfindex() {
        return CodeHelpers.require(getIfindex(), "ifindex");
    }
    
    /**
     * Return adminStatus, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The desired state of the interface. In RFC 7223 this leaf has the same read
     *         semantics as ifAdminStatus. Here, it reflects the administrative state as set by
     *         enabling or disabling the interface.
     *     </code>
     * </pre>
     *
     * @return {@code AdminStatus} adminStatus, or {@code null} if it is not present.
     *
     */
    AdminStatus getAdminStatus();
    
    /**
     * Return adminStatus, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The desired state of the interface. In RFC 7223 this leaf has the same read
     *         semantics as ifAdminStatus. Here, it reflects the administrative state as set by
     *         enabling or disabling the interface.
     *     </code>
     * </pre>
     *
     * @return {@code AdminStatus} adminStatus, guaranteed to be non-null.
     * @throws NoSuchElementException if adminStatus is not present
     *
     */
    default @NonNull AdminStatus requireAdminStatus() {
        return CodeHelpers.require(getAdminStatus(), "adminstatus");
    }
    
    /**
     * Return operStatus, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The current operational state of the interface. This leaf has the same semantics
     *         as ifOperStatus.
     *     </code>
     * </pre>
     *
     * @return {@code OperStatus} operStatus, or {@code null} if it is not present.
     *
     */
    OperStatus getOperStatus();
    
    /**
     * Return operStatus, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The current operational state of the interface. This leaf has the same semantics
     *         as ifOperStatus.
     *     </code>
     * </pre>
     *
     * @return {@code OperStatus} operStatus, guaranteed to be non-null.
     * @throws NoSuchElementException if operStatus is not present
     *
     */
    default @NonNull OperStatus requireOperStatus() {
        return CodeHelpers.require(getOperStatus(), "operstatus");
    }
    
    /**
     * Return lastChange, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         This timestamp indicates the absolute time of the last state change of the
     *         interface (e.g., up-to-down transition). This is different than the SNMP
     *         ifLastChange object in the standard interface MIB in that it is not relative to
     *         the system boot time (i.e,. sysUpTime). The value is the timestamp in
     *         nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
     *     </code>
     * </pre>
     *
     * @return {@code Timeticks64} lastChange, or {@code null} if it is not present.
     *
     */
    Timeticks64 getLastChange();
    
    /**
     * Return lastChange, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         This timestamp indicates the absolute time of the last state change of the
     *         interface (e.g., up-to-down transition). This is different than the SNMP
     *         ifLastChange object in the standard interface MIB in that it is not relative to
     *         the system boot time (i.e,. sysUpTime). The value is the timestamp in
     *         nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
     *     </code>
     * </pre>
     *
     * @return {@code Timeticks64} lastChange, guaranteed to be non-null.
     * @throws NoSuchElementException if lastChange is not present
     *
     */
    default @NonNull Timeticks64 requireLastChange() {
        return CodeHelpers.require(getLastChange(), "lastchange");
    }
    
    /**
     * Return logical, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When set to true, the interface is a logical interface which does not have an
     *         associated physical port or channel on the system.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} logical, or {@code null} if it is not present.
     *
     */
    Boolean getLogical();
    
    /**
     * Return logical, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When set to true, the interface is a logical interface which does not have an
     *         associated physical port or channel on the system.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} logical, guaranteed to be non-null.
     * @throws NoSuchElementException if logical is not present
     *
     */
    default @NonNull Boolean requireLogical() {
        return CodeHelpers.require(getLogical(), "logical");
    }
    
    /**
     * Return management, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When set to true, the interface is a dedicated management interface that is not
     *         connected to dataplane interfaces. It may be used to connect the system to an
     *         out-of-band management network, for example.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} management, or {@code null} if it is not present.
     *
     */
    Boolean getManagement();
    
    /**
     * Return management, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When set to true, the interface is a dedicated management interface that is not
     *         connected to dataplane interfaces. It may be used to connect the system to an
     *         out-of-band management network, for example.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} management, guaranteed to be non-null.
     * @throws NoSuchElementException if management is not present
     *
     */
    default @NonNull Boolean requireManagement() {
        return CodeHelpers.require(getManagement(), "management");
    }
    
    /**
     * Return cpu, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When set to true, the interface is for traffic that is handled by the system
     *         CPU, sometimes also called the control plane interface. On systems that
     *         represent the CPU interface as an Ethernet interface, for example, this leaf
     *         should be used to distinguish the CPU interface from dataplane interfaces.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} cpu, or {@code null} if it is not present.
     *
     */
    Boolean getCpu();
    
    /**
     * Return cpu, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When set to true, the interface is for traffic that is handled by the system
     *         CPU, sometimes also called the control plane interface. On systems that
     *         represent the CPU interface as an Ethernet interface, for example, this leaf
     *         should be used to distinguish the CPU interface from dataplane interfaces.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} cpu, guaranteed to be non-null.
     * @throws NoSuchElementException if cpu is not present
     *
     */
    default @NonNull Boolean requireCpu() {
        return CodeHelpers.require(getCpu(), "cpu");
    }

}

