package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ETHERNETSPEED;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Config} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Config createConfig(int fooXyzzy, int barBaz) {
 *         return new ConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Config, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Config
 *
 */
@Generated("mdsal-binding-generator")
public class ConfigBuilder {

    private Boolean _autoNegotiate;
    private DuplexMode _duplexMode;
    private Boolean _enableFlowControl;
    private MacAddress _macAddress;
    private ETHERNETSPEED _portSpeed;
    private Boolean _standaloneLinkTraining;


    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConfigBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link EthernetInterfaceConfig}.
     *
     * @param arg EthernetInterfaceConfig from which the builder should be initialized
     */
    public ConfigBuilder(EthernetInterfaceConfig arg) {
        this._macAddress = arg.getMacAddress();
        this._autoNegotiate = arg.getAutoNegotiate();
        this._standaloneLinkTraining = arg.getStandaloneLinkTraining();
        this._duplexMode = arg.getDuplexMode();
        this._portSpeed = arg.getPortSpeed();
        this._enableFlowControl = arg.getEnableFlowControl();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Config}.
     *
     * @param base Config from which the builder should be initialized
     */
    public ConfigBuilder(Config base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._autoNegotiate = base.getAutoNegotiate();
        this._duplexMode = base.getDuplexMode();
        this._enableFlowControl = base.getEnableFlowControl();
        this._macAddress = base.getMacAddress();
        this._portSpeed = base.getPortSpeed();
        this._standaloneLinkTraining = base.getStandaloneLinkTraining();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link EthernetInterfaceConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetInterfaceConfig castArg) {
            this._macAddress = castArg.getMacAddress();
            this._autoNegotiate = castArg.getAutoNegotiate();
            this._standaloneLinkTraining = castArg.getStandaloneLinkTraining();
            this._duplexMode = castArg.getDuplexMode();
            this._portSpeed = castArg.getPortSpeed();
            this._enableFlowControl = castArg.getEnableFlowControl();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EthernetInterfaceConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Config#getAutoNegotiate()}.
     *
     * @return current value
     */
    public Boolean getAutoNegotiate() {
        return _autoNegotiate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getDuplexMode()}.
     *
     * @return current value
     */
    public DuplexMode getDuplexMode() {
        return _duplexMode;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getEnableFlowControl()}.
     *
     * @return current value
     */
    public Boolean getEnableFlowControl() {
        return _enableFlowControl;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getMacAddress()}.
     *
     * @return current value
     */
    public MacAddress getMacAddress() {
        return _macAddress;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getPortSpeed()}.
     *
     * @return current value
     */
    public ETHERNETSPEED getPortSpeed() {
        return _portSpeed;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getStandaloneLinkTraining()}.
     *
     * @return current value
     */
    public Boolean getStandaloneLinkTraining() {
        return _standaloneLinkTraining;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Config#getAutoNegotiate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setAutoNegotiate(final Boolean value) {
        this._autoNegotiate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getDuplexMode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setDuplexMode(final DuplexMode value) {
        this._duplexMode = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getEnableFlowControl()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setEnableFlowControl(final Boolean value) {
        this._enableFlowControl = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getMacAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setMacAddress(final MacAddress value) {
        this._macAddress = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getPortSpeed()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setPortSpeed(final ETHERNETSPEED value) {
        this._portSpeed = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getStandaloneLinkTraining()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setStandaloneLinkTraining(final Boolean value) {
        this._standaloneLinkTraining = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Config} instance.
     *
     * @return A new {@link Config} instance.
     */
    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
        extends AbstractAugmentable<Config>
        implements Config {
    
        private final Boolean _autoNegotiate;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode _duplexMode;
        private final Boolean _enableFlowControl;
        private final MacAddress _macAddress;
        private final ETHERNETSPEED _portSpeed;
        private final Boolean _standaloneLinkTraining;
    
        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._autoNegotiate = base.getAutoNegotiate();
            this._duplexMode = base.getDuplexMode();
            this._enableFlowControl = base.getEnableFlowControl();
            this._macAddress = base.getMacAddress();
            this._portSpeed = base.getPortSpeed();
            this._standaloneLinkTraining = base.getStandaloneLinkTraining();
        }
    
        @Override
        public Boolean getAutoNegotiate() {
            return _autoNegotiate;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode getDuplexMode() {
            return _duplexMode;
        }
        
        @Override
        public Boolean getEnableFlowControl() {
            return _enableFlowControl;
        }
        
        @Override
        public MacAddress getMacAddress() {
            return _macAddress;
        }
        
        @Override
        public ETHERNETSPEED getPortSpeed() {
            return _portSpeed;
        }
        
        @Override
        public Boolean getStandaloneLinkTraining() {
            return _standaloneLinkTraining;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Config.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Config.bindingToString(this);
        }
    }
}
