package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Model for managing Ethernet interfaces -- augments the OpenConfig model for 
 * interface configuration and state.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
 * <pre>
 * module openconfig-if-ethernet {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/interfaces/ethernet";
 *   prefix oc-eth;
 *   import openconfig-interfaces {
 *     prefix oc-if;
 *   }
 *   import iana-if-type {
 *     prefix ianaift;
 *   }
 *   import openconfig-yang-types {
 *     prefix oc-yang;
 *   }
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   oc-ext:openconfig-version 2.11.0;
 *   revision 2021-06-09 {
 *   }
 *   revision 2021-05-17 {
 *   }
 *   revision 2021-03-30 {
 *   }
 *   revision 2020-05-06 {
 *   }
 *   revision 2020-05-06 {
 *   }
 *   revision 2020-05-05 {
 *   }
 *   revision 2019-04-16 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2018-09-04 {
 *   }
 *   revision 2018-08-28 {
 *   }
 *   revision 2018-07-02 {
 *   }
 *   revision 2018-04-10 {
 *   }
 *   revision 2018-01-05 {
 *   }
 *   revision 2017-12-21 {
 *   }
 *   revision 2017-07-14 {
 *   }
 *   revision 2016-12-22 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   identity ETHERNET_SPEED {
 *   }
 *   identity SPEED_10MB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_100MB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_1GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_2500MB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_5GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_10GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_25GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_40GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_50GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_100GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_200GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_400GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_600GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_800GB {
 *     base ETHERNET_SPEED;
 *   }
 *   identity SPEED_UNKNOWN {
 *     base ETHERNET_SPEED;
 *   }
 *   grouping ethernet-interface-config {
 *     leaf mac-address {
 *       type oc-yang:mac-address;
 *     }
 *     leaf auto-negotiate {
 *       type boolean;
 *       default true;
 *     }
 *     leaf standalone-link-training {
 *       type boolean;
 *       default false;
 *     }
 *     leaf duplex-mode {
 *       type enumeration {
 *         enum FULL {
 *         }
 *         enum HALF {
 *         }
 *       }
 *     }
 *     leaf port-speed {
 *       type identityref {
 *         base ETHERNET_SPEED;
 *       }
 *     }
 *     leaf enable-flow-control {
 *       type boolean;
 *       default false;
 *     }
 *   }
 *   grouping ethernet-interface-state-counters {
 *     leaf in-mac-control-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-mac-pause-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-oversize-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-undersize-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-jabber-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-fragment-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-8021q-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-crc-errors {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-block-errors {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-carrier-errors {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-interrupted-tx {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-late-collision {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-mac-errors-rx {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-single-collision {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-symbol-error {
 *       type oc-yang:counter64;
 *     }
 *     leaf in-maxsize-exceeded {
 *       type oc-yang:counter64;
 *     }
 *     leaf out-mac-control-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf out-mac-pause-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf out-8021q-frames {
 *       type oc-yang:counter64;
 *     }
 *     leaf out-mac-errors-tx {
 *       type oc-yang:counter64;
 *     }
 *   }
 *   grouping ethernet-interface-state {
 *     leaf hw-mac-address {
 *       type oc-yang:mac-address;
 *     }
 *     leaf negotiated-duplex-mode {
 *       type enumeration {
 *         enum FULL {
 *         }
 *         enum HALF {
 *         }
 *       }
 *     }
 *     leaf negotiated-port-speed {
 *       type identityref {
 *         base ETHERNET_SPEED;
 *       }
 *     }
 *     container counters {
 *       uses ethernet-interface-state-counters;
 *     }
 *   }
 *   grouping ethernet-top {
 *     container ethernet {
 *       container config {
 *         uses ethernet-interface-config;
 *       }
 *       container state {
 *         config false;
 *         uses ethernet-interface-config;
 *         uses ethernet-interface-state;
 *       }
 *     }
 *   }
 *   augment /oc-if:interfaces/oc-if:interface {
 *     uses ethernet-top {
 *       when "oc-if:config/oc-if:type = 'ianaift:ethernetCsmacd'" {
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigIfEthernetData
    extends
    DataRoot
{





}

