package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Operational state data for aggregate interfaces
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-aggregate</b>
 * <pre>
 * grouping aggregation-logical-state {
 *   leaf lag-speed {
 *     type uint32;
 *     units Mbps;
 *   }
 *   leaf-list member {
 *     when "../../config/lag-type = 'STATIC'" {
 *     }
 *     type oc-if:base-interface-ref;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AggregationLogicalState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aggregation-logical-state");

    @Override
    Class<? extends AggregationLogicalState> implementedInterface();
    
    /**
     * Return lagSpeed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reports effective speed of the aggregate interface, based on speed of active
     *         member interfaces
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} lagSpeed, or {@code null} if it is not present.
     *
     */
    Uint32 getLagSpeed();
    
    /**
     * Return lagSpeed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reports effective speed of the aggregate interface, based on speed of active
     *         member interfaces
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} lagSpeed, guaranteed to be non-null.
     * @throws NoSuchElementException if lagSpeed is not present
     *
     */
    default @NonNull Uint32 requireLagSpeed() {
        return CodeHelpers.require(getLagSpeed(), "lagspeed");
    }
    
    /**
     * Return member, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of current member interfaces for the aggregate, expressed as references to
     *         existing interfaces
     *     </code>
     * </pre>
     *
     * @return {@code Set<String>} member, or {@code null} if it is not present.
     *
     */
    @Nullable Set<String> getMember();
    
    /**
     * Return member, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         List of current member interfaces for the aggregate, expressed as references to
     *         existing interfaces
     *     </code>
     * </pre>
     *
     * @return {@code Set<String>} member, guaranteed to be non-null.
     * @throws NoSuchElementException if member is not present
     *
     */
    default @NonNull Set<String> requireMember() {
        return CodeHelpers.require(getMember(), "member");
    }

}

