package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Indicates that a service affecting condition has occurred and an immediate 
 * corrective action is required. Such a severity can be reported, for example, 
 * when a resource becomes totally out of service and its capability must be 
 * restored.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarm-types</b>
 * <pre>
 * identity CRITICAL {
 *   base OPENCONFIG_ALARM_SEVERITY;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface CRITICAL
    extends
    OPENCONFIGALARMSEVERITY
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("CRITICAL");
    /**
     * Singleton value representing the {@link CRITICAL} identity.
     */
    public static final @NonNull CRITICAL VALUE = new CRITICAL() {
        @Override
        public Class<CRITICAL> implementedInterface() {
            return CRITICAL.class;
        }
    
        @Override
        public int hashCode() {
            return CRITICAL.class.hashCode();
        }
    
        @Override
        public boolean equals(final Object obj) {
            return obj == this || obj instanceof CRITICAL other
                && CRITICAL.class.equals(other.implementedInterface());
        }
    
        @Override
        public String toString() {
            return MoreObjects.toStringHelper("CRITICAL").add("qname", QNAME).toString();
        }
    };

    @Override
    Class<? extends CRITICAL> implementedInterface();

}

