package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Server} class.
 *
 * @see Server
 *
 */
@Generated("mdsal-binding-generator")
public class ServerKey
 implements Identifier<Server> {
    private static final long serialVersionUID = 2606499796350152059L;
    private final IpAddress _address;


    /**
     * Constructs an instance.
     *
     * @param _address the entity address
     * @throws NullPointerException if any of the arguments are null
     */
    public ServerKey(@NonNull IpAddress _address) {
        this._address = CodeHelpers.requireKeyProp(_address, "address");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ServerKey(ServerKey source) {
        this._address = source._address;
    }


    /**
     * Return address, guaranteed to be non-null.
     *
     * @return {@code IpAddress} address, guaranteed to be non-null.
     */
    public @NonNull IpAddress getAddress() {
        return _address;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_address);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServerKey)) {
            return false;
        }
        final ServerKey other = (ServerKey) obj;
        if (!Objects.equals(_address, other._address)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(ServerKey.class);
        CodeHelpers.appendValue(helper, "address", _address);
        return helper.toString();
    }
}

