package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link User} class.
 *
 * @see User
 *
 */
@Generated("mdsal-binding-generator")
public class UserKey
 implements Identifier<User> {
    private static final long serialVersionUID = 8287460623465640735L;
    private final String _username;


    /**
     * Constructs an instance.
     *
     * @param _username the entity username
     * @throws NullPointerException if any of the arguments are null
     */
    public UserKey(@NonNull String _username) {
        this._username = CodeHelpers.requireKeyProp(_username, "username");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public UserKey(UserKey source) {
        this._username = source._username;
    }


    /**
     * Return username, guaranteed to be non-null.
     *
     * @return {@code String} username, guaranteed to be non-null.
     */
    public @NonNull String getUsername() {
        return _username;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_username);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserKey)) {
            return false;
        }
        final UserKey other = (UserKey) obj;
        if (!Objects.equals(_username, other._username)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(UserKey.class);
        CodeHelpers.appendValue(helper, "username", _username);
        return helper.toString();
    }
}

