package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.admin.top.admin.user;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAdminConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAdminState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private String _adminPassword;
    private CryptPasswordType _adminPasswordHashed;
    private String _adminUsername;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link AaaAdminConfig}.
     *
     * @param arg AaaAdminConfig from which the builder should be initialized
     */
    public StateBuilder(AaaAdminConfig arg) {
        this._adminPassword = arg.getAdminPassword();
        this._adminPasswordHashed = arg.getAdminPasswordHashed();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AaaAdminState}.
     *
     * @param arg AaaAdminState from which the builder should be initialized
     */
    public StateBuilder(AaaAdminState arg) {
        this._adminUsername = arg.getAdminUsername();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._adminPassword = base.getAdminPassword();
        this._adminPasswordHashed = base.getAdminPasswordHashed();
        this._adminUsername = base.getAdminUsername();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link AaaAdminState}</li>
     *   <li>{@link AaaAdminConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaAdminState castArg) {
            this._adminUsername = castArg.getAdminUsername();
            isValidArg = true;
        }
        if (arg instanceof AaaAdminConfig castArg) {
            this._adminPassword = castArg.getAdminPassword();
            this._adminPasswordHashed = castArg.getAdminPasswordHashed();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaAdminState, AaaAdminConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getAdminPassword()}.
     *
     * @return current value
     */
    public String getAdminPassword() {
        return _adminPassword;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getAdminPasswordHashed()}.
     *
     * @return current value
     */
    public CryptPasswordType getAdminPasswordHashed() {
        return _adminPasswordHashed;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getAdminUsername()}.
     *
     * @return current value
     */
    public String getAdminUsername() {
        return _adminUsername;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getAdminPassword()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAdminPassword(final String value) {
        this._adminPassword = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getAdminPasswordHashed()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAdminPasswordHashed(final CryptPasswordType value) {
        this._adminPasswordHashed = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getAdminUsername()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAdminUsername(final String value) {
        this._adminUsername = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final String _adminPassword;
        private final CryptPasswordType _adminPasswordHashed;
        private final String _adminUsername;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._adminPassword = base.getAdminPassword();
            this._adminPasswordHashed = base.getAdminPasswordHashed();
            this._adminUsername = base.getAdminUsername();
        }
    
        @Override
        public String getAdminPassword() {
            return _adminPassword;
        }
        
        @Override
        public CryptPasswordType getAdminPasswordHashed() {
            return _adminPasswordHashed;
        }
        
        @Override
        public String getAdminUsername() {
            return _adminUsername;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
