/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpAuthKeysTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.NtpKeys;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.Servers;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.Ntp;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NtpBuilder {
    private Config _config;
    private NtpKeys _ntpKeys;
    private Servers _servers;
    private State _state;
    Map<Class<? extends Augmentation<Ntp>>, Augmentation<Ntp>> augmentation = Map.of();

    public NtpBuilder() {
    }

    public NtpBuilder(SystemNtpAuthKeysTop arg) {
        this._ntpKeys = arg.getNtpKeys();
    }

    public NtpBuilder(SystemNtpServerTop arg) {
        this._servers = arg.getServers();
    }

    public NtpBuilder(Ntp base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ntp>>, Augmentation<Ntp>>(aug);
        }
        this._config = base.getConfig();
        this._ntpKeys = base.getNtpKeys();
        this._servers = base.getServers();
        this._state = base.getState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpAuthKeysTop) {
            this._ntpKeys = ((SystemNtpAuthKeysTop)arg).getNtpKeys();
            isValidArg = true;
        }
        if (arg instanceof SystemNtpServerTop) {
            this._servers = ((SystemNtpServerTop)arg).getServers();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemNtpAuthKeysTop, SystemNtpServerTop]");
    }

    public Config getConfig() {
        return this._config;
    }

    public NtpKeys getNtpKeys() {
        return this._ntpKeys;
    }

    public Servers getServers() {
        return this._servers;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Ntp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NtpBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public NtpBuilder setNtpKeys(NtpKeys value) {
        this._ntpKeys = value;
        return this;
    }

    public NtpBuilder setServers(Servers value) {
        this._servers = value;
        return this;
    }

    public NtpBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public NtpBuilder addAugmentation(Augmentation<Ntp> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ntp>>, Augmentation<Ntp>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public NtpBuilder removeAugmentation(Class<? extends Augmentation<Ntp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Ntp build() {
        return new NtpImpl(this);
    }

    private static final class NtpImpl
    extends AbstractAugmentable<Ntp>
    implements Ntp {
        private final Config _config;
        private final NtpKeys _ntpKeys;
        private final Servers _servers;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NtpImpl(NtpBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._ntpKeys = base.getNtpKeys();
            this._servers = base.getServers();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public NtpKeys getNtpKeys() {
            return this._ntpKeys;
        }

        @Override
        public Servers getServers() {
            return this._servers;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Ntp.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Ntp.bindingEquals(this, obj);
        }

        public String toString() {
            return Ntp.bindingToString(this);
        }
    }
}

