/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

public interface SystemNtpServerConfig
extends DataObject {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-ntp-server-config");

    public Class<? extends SystemNtpServerConfig> implementedInterface();

    public Host getAddress();

    default public @NonNull Host requireAddress() {
        return (Host)CodeHelpers.require((Object)this.getAddress(), (String)"address");
    }

    public PortNumber getPort();

    default public @NonNull PortNumber requirePort() {
        return (PortNumber)CodeHelpers.require((Object)this.getPort(), (String)"port");
    }

    public Uint8 getVersion();

    default public @NonNull Uint8 requireVersion() {
        return (Uint8)CodeHelpers.require((Object)this.getVersion(), (String)"version");
    }

    public AssociationType getAssociationType();

    default public @NonNull AssociationType requireAssociationType() {
        return (AssociationType)((Object)CodeHelpers.require((Object)((Object)this.getAssociationType()), (String)"associationtype"));
    }

    public Boolean getIburst();

    default public @NonNull Boolean requireIburst() {
        return (Boolean)CodeHelpers.require((Object)this.getIburst(), (String)"iburst");
    }

    public Boolean getPrefer();

    default public @NonNull Boolean requirePrefer() {
        return (Boolean)CodeHelpers.require((Object)this.getPrefer(), (String)"prefer");
    }

    public static enum AssociationType implements Enumeration
    {
        SERVER(0, "SERVER"),
        PEER(1, "PEER"),
        POOL(2, "POOL");

        private static final Map<String, AssociationType> NAME_MAP;
        private static final Map<Integer, AssociationType> VALUE_MAP;
        private final String name;
        private final int value;

        private AssociationType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<AssociationType> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static AssociationType forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (AssociationType enumItem : AssociationType.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

