/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformAnchorsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentPropertiesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformSubcomponentRefTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Backplane;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Chassis;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Cpu;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Fabric;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Fan;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.IntegratedCircuit;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Port;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.PowerSupply;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.SoftwareModule;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Storage;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.Properties;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.Component;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.ComponentKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.Subcomponents;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ComponentBuilder {
    private Backplane _backplane;
    private Chassis _chassis;
    private Config _config;
    private Cpu _cpu;
    private Fabric _fabric;
    private Fan _fan;
    private IntegratedCircuit _integratedCircuit;
    private String _name;
    private Port _port;
    private PowerSupply _powerSupply;
    private Properties _properties;
    private SoftwareModule _softwareModule;
    private State _state;
    private Storage _storage;
    private Subcomponents _subcomponents;
    private ComponentKey key;
    Map<Class<? extends Augmentation<Component>>, Augmentation<Component>> augmentation = Map.of();

    public ComponentBuilder() {
    }

    public ComponentBuilder(PlatformComponentPropertiesTop arg) {
        this._properties = arg.getProperties();
    }

    public ComponentBuilder(PlatformSubcomponentRefTop arg) {
        this._subcomponents = arg.getSubcomponents();
    }

    public ComponentBuilder(PlatformAnchorsTop arg) {
        this._chassis = arg.getChassis();
        this._port = arg.getPort();
        this._powerSupply = arg.getPowerSupply();
        this._fan = arg.getFan();
        this._fabric = arg.getFabric();
        this._storage = arg.getStorage();
        this._cpu = arg.getCpu();
        this._integratedCircuit = arg.getIntegratedCircuit();
        this._backplane = arg.getBackplane();
        this._softwareModule = arg.getSoftwareModule();
    }

    public ComponentBuilder(Component base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Component>>, Augmentation<Component>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._backplane = base.getBackplane();
        this._chassis = base.getChassis();
        this._config = base.getConfig();
        this._cpu = base.getCpu();
        this._fabric = base.getFabric();
        this._fan = base.getFan();
        this._integratedCircuit = base.getIntegratedCircuit();
        this._port = base.getPort();
        this._powerSupply = base.getPowerSupply();
        this._properties = base.getProperties();
        this._softwareModule = base.getSoftwareModule();
        this._state = base.getState();
        this._storage = base.getStorage();
        this._subcomponents = base.getSubcomponents();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PlatformSubcomponentRefTop) {
            this._subcomponents = ((PlatformSubcomponentRefTop)arg).getSubcomponents();
            isValidArg = true;
        }
        if (arg instanceof PlatformAnchorsTop) {
            this._chassis = ((PlatformAnchorsTop)arg).getChassis();
            this._port = ((PlatformAnchorsTop)arg).getPort();
            this._powerSupply = ((PlatformAnchorsTop)arg).getPowerSupply();
            this._fan = ((PlatformAnchorsTop)arg).getFan();
            this._fabric = ((PlatformAnchorsTop)arg).getFabric();
            this._storage = ((PlatformAnchorsTop)arg).getStorage();
            this._cpu = ((PlatformAnchorsTop)arg).getCpu();
            this._integratedCircuit = ((PlatformAnchorsTop)arg).getIntegratedCircuit();
            this._backplane = ((PlatformAnchorsTop)arg).getBackplane();
            this._softwareModule = ((PlatformAnchorsTop)arg).getSoftwareModule();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentPropertiesTop) {
            this._properties = ((PlatformComponentPropertiesTop)arg).getProperties();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[PlatformSubcomponentRefTop, PlatformAnchorsTop, PlatformComponentPropertiesTop]");
    }

    public ComponentKey key() {
        return this.key;
    }

    public Backplane getBackplane() {
        return this._backplane;
    }

    public Chassis getChassis() {
        return this._chassis;
    }

    public Config getConfig() {
        return this._config;
    }

    public Cpu getCpu() {
        return this._cpu;
    }

    public Fabric getFabric() {
        return this._fabric;
    }

    public Fan getFan() {
        return this._fan;
    }

    public IntegratedCircuit getIntegratedCircuit() {
        return this._integratedCircuit;
    }

    public String getName() {
        return this._name;
    }

    public Port getPort() {
        return this._port;
    }

    public PowerSupply getPowerSupply() {
        return this._powerSupply;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public SoftwareModule getSoftwareModule() {
        return this._softwareModule;
    }

    public State getState() {
        return this._state;
    }

    public Storage getStorage() {
        return this._storage;
    }

    public Subcomponents getSubcomponents() {
        return this._subcomponents;
    }

    public <E$$ extends Augmentation<Component>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ComponentBuilder withKey(ComponentKey key) {
        this.key = key;
        return this;
    }

    public ComponentBuilder setBackplane(Backplane value) {
        this._backplane = value;
        return this;
    }

    public ComponentBuilder setChassis(Chassis value) {
        this._chassis = value;
        return this;
    }

    public ComponentBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public ComponentBuilder setCpu(Cpu value) {
        this._cpu = value;
        return this;
    }

    public ComponentBuilder setFabric(Fabric value) {
        this._fabric = value;
        return this;
    }

    public ComponentBuilder setFan(Fan value) {
        this._fan = value;
        return this;
    }

    public ComponentBuilder setIntegratedCircuit(IntegratedCircuit value) {
        this._integratedCircuit = value;
        return this;
    }

    public ComponentBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ComponentBuilder setPort(Port value) {
        this._port = value;
        return this;
    }

    public ComponentBuilder setPowerSupply(PowerSupply value) {
        this._powerSupply = value;
        return this;
    }

    public ComponentBuilder setProperties(Properties value) {
        this._properties = value;
        return this;
    }

    public ComponentBuilder setSoftwareModule(SoftwareModule value) {
        this._softwareModule = value;
        return this;
    }

    public ComponentBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ComponentBuilder setStorage(Storage value) {
        this._storage = value;
        return this;
    }

    public ComponentBuilder setSubcomponents(Subcomponents value) {
        this._subcomponents = value;
        return this;
    }

    public ComponentBuilder addAugmentation(Augmentation<Component> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Component>>, Augmentation<Component>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ComponentBuilder removeAugmentation(Class<? extends Augmentation<Component>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Component build() {
        return new ComponentImpl(this);
    }

    private static final class ComponentImpl
    extends AbstractAugmentable<Component>
    implements Component {
        private final Backplane _backplane;
        private final Chassis _chassis;
        private final Config _config;
        private final Cpu _cpu;
        private final Fabric _fabric;
        private final Fan _fan;
        private final IntegratedCircuit _integratedCircuit;
        private final String _name;
        private final Port _port;
        private final PowerSupply _powerSupply;
        private final Properties _properties;
        private final SoftwareModule _softwareModule;
        private final State _state;
        private final Storage _storage;
        private final Subcomponents _subcomponents;
        private final ComponentKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ComponentImpl(ComponentBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ComponentKey(base.getName());
            this._name = this.key.getName();
            this._backplane = base.getBackplane();
            this._chassis = base.getChassis();
            this._config = base.getConfig();
            this._cpu = base.getCpu();
            this._fabric = base.getFabric();
            this._fan = base.getFan();
            this._integratedCircuit = base.getIntegratedCircuit();
            this._port = base.getPort();
            this._powerSupply = base.getPowerSupply();
            this._properties = base.getProperties();
            this._softwareModule = base.getSoftwareModule();
            this._state = base.getState();
            this._storage = base.getStorage();
            this._subcomponents = base.getSubcomponents();
        }

        @Override
        public ComponentKey key() {
            return this.key;
        }

        @Override
        public Backplane getBackplane() {
            return this._backplane;
        }

        @Override
        public Chassis getChassis() {
            return this._chassis;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Cpu getCpu() {
            return this._cpu;
        }

        @Override
        public Fabric getFabric() {
            return this._fabric;
        }

        @Override
        public Fan getFan() {
            return this._fan;
        }

        @Override
        public IntegratedCircuit getIntegratedCircuit() {
            return this._integratedCircuit;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Port getPort() {
            return this._port;
        }

        @Override
        public PowerSupply getPowerSupply() {
            return this._powerSupply;
        }

        @Override
        public Properties getProperties() {
            return this._properties;
        }

        @Override
        public SoftwareModule getSoftwareModule() {
            return this._softwareModule;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Storage getStorage() {
            return this._storage;
        }

        @Override
        public Subcomponents getSubcomponents() {
            return this._subcomponents;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Component.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Component.bindingEquals(this, obj);
        }

        public String toString() {
            return Component.bindingToString(this);
        }
    }
}

