/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ETHERNETSPEED;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

public interface EthernetInterfaceState
extends DataObject {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-interface-state");

    public Class<? extends EthernetInterfaceState> implementedInterface();

    public MacAddress getHwMacAddress();

    default public @NonNull MacAddress requireHwMacAddress() {
        return (MacAddress)CodeHelpers.require((Object)this.getHwMacAddress(), (String)"hwmacaddress");
    }

    public NegotiatedDuplexMode getNegotiatedDuplexMode();

    default public @NonNull NegotiatedDuplexMode requireNegotiatedDuplexMode() {
        return (NegotiatedDuplexMode)((Object)CodeHelpers.require((Object)((Object)this.getNegotiatedDuplexMode()), (String)"negotiatedduplexmode"));
    }

    public Class<? extends ETHERNETSPEED> getNegotiatedPortSpeed();

    default public @NonNull Class<? extends ETHERNETSPEED> requireNegotiatedPortSpeed() {
        return (Class)CodeHelpers.require(this.getNegotiatedPortSpeed(), (String)"negotiatedportspeed");
    }

    public Counters getCounters();

    public static enum NegotiatedDuplexMode implements Enumeration
    {
        FULL(0, "FULL"),
        HALF(1, "HALF");

        private static final Map<String, NegotiatedDuplexMode> NAME_MAP;
        private static final Map<Integer, NegotiatedDuplexMode> VALUE_MAP;
        private final String name;
        private final int value;

        private NegotiatedDuplexMode(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<NegotiatedDuplexMode> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static NegotiatedDuplexMode forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (NegotiatedDuplexMode enumItem : NegotiatedDuplexMode.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

