/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.radius;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.radius.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.RoutingPassword;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class StateBuilder {
    private PortNumber _acctPort;
    private PortNumber _authPort;
    private Counters _counters;
    private Uint8 _retransmitAttempts;
    private RoutingPassword _secretKey;
    private CryptPasswordType _secretKeyHashed;
    private IpAddress _sourceAddress;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(AaaRadiusServerConfig arg) {
        this._authPort = arg.getAuthPort();
        this._acctPort = arg.getAcctPort();
        this._secretKey = arg.getSecretKey();
        this._secretKeyHashed = arg.getSecretKeyHashed();
        this._sourceAddress = arg.getSourceAddress();
        this._retransmitAttempts = arg.getRetransmitAttempts();
    }

    public StateBuilder(AaaRadiusServerState arg) {
        this._counters = arg.getCounters();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._acctPort = base.getAcctPort();
        this._authPort = base.getAuthPort();
        this._counters = base.getCounters();
        this._retransmitAttempts = base.getRetransmitAttempts();
        this._secretKey = base.getSecretKey();
        this._secretKeyHashed = base.getSecretKeyHashed();
        this._sourceAddress = base.getSourceAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaRadiusServerConfig) {
            this._authPort = ((AaaRadiusServerConfig)arg).getAuthPort();
            this._acctPort = ((AaaRadiusServerConfig)arg).getAcctPort();
            this._secretKey = ((AaaRadiusServerConfig)arg).getSecretKey();
            this._secretKeyHashed = ((AaaRadiusServerConfig)arg).getSecretKeyHashed();
            this._sourceAddress = ((AaaRadiusServerConfig)arg).getSourceAddress();
            this._retransmitAttempts = ((AaaRadiusServerConfig)arg).getRetransmitAttempts();
            isValidArg = true;
        }
        if (arg instanceof AaaRadiusServerState) {
            this._counters = ((AaaRadiusServerState)arg).getCounters();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaRadiusServerConfig, AaaRadiusServerState]");
    }

    public PortNumber getAcctPort() {
        return this._acctPort;
    }

    public PortNumber getAuthPort() {
        return this._authPort;
    }

    public Counters getCounters() {
        return this._counters;
    }

    public Uint8 getRetransmitAttempts() {
        return this._retransmitAttempts;
    }

    public RoutingPassword getSecretKey() {
        return this._secretKey;
    }

    public CryptPasswordType getSecretKeyHashed() {
        return this._secretKeyHashed;
    }

    public IpAddress getSourceAddress() {
        return this._sourceAddress;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAcctPort(PortNumber value) {
        this._acctPort = value;
        return this;
    }

    public StateBuilder setAuthPort(PortNumber value) {
        this._authPort = value;
        return this;
    }

    public StateBuilder setCounters(Counters value) {
        this._counters = value;
        return this;
    }

    public StateBuilder setRetransmitAttempts(Uint8 value) {
        this._retransmitAttempts = value;
        return this;
    }

    public StateBuilder setSecretKey(RoutingPassword value) {
        this._secretKey = value;
        return this;
    }

    public StateBuilder setSecretKeyHashed(CryptPasswordType value) {
        this._secretKeyHashed = value;
        return this;
    }

    public StateBuilder setSourceAddress(IpAddress value) {
        this._sourceAddress = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final PortNumber _acctPort;
        private final PortNumber _authPort;
        private final Counters _counters;
        private final Uint8 _retransmitAttempts;
        private final RoutingPassword _secretKey;
        private final CryptPasswordType _secretKeyHashed;
        private final IpAddress _sourceAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._acctPort = base.getAcctPort();
            this._authPort = base.getAuthPort();
            this._counters = base.getCounters();
            this._retransmitAttempts = base.getRetransmitAttempts();
            this._secretKey = base.getSecretKey();
            this._secretKeyHashed = base.getSecretKeyHashed();
            this._sourceAddress = base.getSourceAddress();
        }

        @Override
        public PortNumber getAcctPort() {
            return this._acctPort;
        }

        @Override
        public PortNumber getAuthPort() {
            return this._authPort;
        }

        @Override
        public Counters getCounters() {
            return this._counters;
        }

        @Override
        public Uint8 getRetransmitAttempts() {
            return this._retransmitAttempts;
        }

        @Override
        public RoutingPassword getSecretKey() {
            return this._secretKey;
        }

        @Override
        public CryptPasswordType getSecretKeyHashed() {
            return this._secretKeyHashed;
        }

        @Override
        public IpAddress getSourceAddress() {
            return this._sourceAddress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

