package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerConfig.AssociationType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Host _address;
    private AssociationType _associationType;
    private Boolean _iburst;
    private Uint64 _offset;
    private Uint32 _pollInterval;
    private PortNumber _port;
    private Boolean _prefer;
    private Uint32 _rootDelay;
    private Uint64 _rootDispersion;
    private Uint8 _stratum;
    private Uint8 _version;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SystemNtpServerConfig}.
     *
     * @param arg SystemNtpServerConfig from which the builder should be initialized
     */
    public StateBuilder(SystemNtpServerConfig arg) {
        this._address = arg.getAddress();
        this._port = arg.getPort();
        this._version = arg.getVersion();
        this._associationType = arg.getAssociationType();
        this._iburst = arg.getIburst();
        this._prefer = arg.getPrefer();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemNtpServerState}.
     *
     * @param arg SystemNtpServerState from which the builder should be initialized
     */
    public StateBuilder(SystemNtpServerState arg) {
        this._stratum = arg.getStratum();
        this._rootDelay = arg.getRootDelay();
        this._rootDispersion = arg.getRootDispersion();
        this._offset = arg.getOffset();
        this._pollInterval = arg.getPollInterval();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._address = base.getAddress();
        this._associationType = base.getAssociationType();
        this._iburst = base.getIburst();
        this._offset = base.getOffset();
        this._pollInterval = base.getPollInterval();
        this._port = base.getPort();
        this._prefer = base.getPrefer();
        this._rootDelay = base.getRootDelay();
        this._rootDispersion = base.getRootDispersion();
        this._stratum = base.getStratum();
        this._version = base.getVersion();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SystemNtpServerState}</li>
     *   <li>{@link SystemNtpServerConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpServerState) {
            this._stratum = ((SystemNtpServerState)arg).getStratum();
            this._rootDelay = ((SystemNtpServerState)arg).getRootDelay();
            this._rootDispersion = ((SystemNtpServerState)arg).getRootDispersion();
            this._offset = ((SystemNtpServerState)arg).getOffset();
            this._pollInterval = ((SystemNtpServerState)arg).getPollInterval();
            isValidArg = true;
        }
        if (arg instanceof SystemNtpServerConfig) {
            this._address = ((SystemNtpServerConfig)arg).getAddress();
            this._port = ((SystemNtpServerConfig)arg).getPort();
            this._version = ((SystemNtpServerConfig)arg).getVersion();
            this._associationType = ((SystemNtpServerConfig)arg).getAssociationType();
            this._iburst = ((SystemNtpServerConfig)arg).getIburst();
            this._prefer = ((SystemNtpServerConfig)arg).getPrefer();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemNtpServerState, SystemNtpServerConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getAddress()}.
     *
     * @return current value
     */
    public Host getAddress() {
        return _address;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getAssociationType()}.
     *
     * @return current value
     */
    public AssociationType getAssociationType() {
        return _associationType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getIburst()}.
     *
     * @return current value
     */
    public Boolean getIburst() {
        return _iburst;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getOffset()}.
     *
     * @return current value
     */
    public Uint64 getOffset() {
        return _offset;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getPollInterval()}.
     *
     * @return current value
     */
    public Uint32 getPollInterval() {
        return _pollInterval;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getPort()}.
     *
     * @return current value
     */
    public PortNumber getPort() {
        return _port;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getPrefer()}.
     *
     * @return current value
     */
    public Boolean getPrefer() {
        return _prefer;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getRootDelay()}.
     *
     * @return current value
     */
    public Uint32 getRootDelay() {
        return _rootDelay;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getRootDispersion()}.
     *
     * @return current value
     */
    public Uint64 getRootDispersion() {
        return _rootDispersion;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getStratum()}.
     *
     * @return current value
     */
    public Uint8 getStratum() {
        return _stratum;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getVersion()}.
     *
     * @return current value
     */
    public Uint8 getVersion() {
        return _version;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAddress(final Host value) {
        this._address = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getAssociationType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAssociationType(final AssociationType value) {
        this._associationType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getIburst()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setIburst(final Boolean value) {
        this._iburst = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getOffset()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setOffset(final Uint64 value) {
        this._offset = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getPollInterval()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setPollInterval(final Uint32 value) {
        this._pollInterval = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getPort()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setPort(final PortNumber value) {
        this._port = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getPrefer()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setPrefer(final Boolean value) {
        this._prefer = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getRootDelay()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setRootDelay(final Uint32 value) {
        this._rootDelay = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getRootDispersion()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setRootDispersion(final Uint64 value) {
        this._rootDispersion = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getStratum()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setStratum(final Uint8 value) {
        this._stratum = value;
        return this;
    }
    
    private static void checkVersionRange(final short value) {
        if (value >= (short)1 && value <= (short)4) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..4]]", value);
    }
    
    /**
     * Set the property corresponding to {@link State#getVersion()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setVersion(final Uint8 value) {
        if (value != null) {
            checkVersionRange(value.shortValue());
            
        }
        this._version = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Host _address;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerConfig.AssociationType _associationType;
        private final Boolean _iburst;
        private final Uint64 _offset;
        private final Uint32 _pollInterval;
        private final PortNumber _port;
        private final Boolean _prefer;
        private final Uint32 _rootDelay;
        private final Uint64 _rootDispersion;
        private final Uint8 _stratum;
        private final Uint8 _version;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._associationType = base.getAssociationType();
            this._iburst = base.getIburst();
            this._offset = base.getOffset();
            this._pollInterval = base.getPollInterval();
            this._port = base.getPort();
            this._prefer = base.getPrefer();
            this._rootDelay = base.getRootDelay();
            this._rootDispersion = base.getRootDispersion();
            this._stratum = base.getStratum();
            this._version = base.getVersion();
        }
    
        @Override
        public Host getAddress() {
            return _address;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerConfig.AssociationType getAssociationType() {
            return _associationType;
        }
        
        @Override
        public Boolean getIburst() {
            return _iburst;
        }
        
        @Override
        public Uint64 getOffset() {
            return _offset;
        }
        
        @Override
        public Uint32 getPollInterval() {
            return _pollInterval;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
        
        @Override
        public Boolean getPrefer() {
            return _prefer;
        }
        
        @Override
        public Uint32 getRootDelay() {
            return _rootDelay;
        }
        
        @Override
        public Uint64 getRootDispersion() {
            return _rootDispersion;
        }
        
        @Override
        public Uint8 getStratum() {
            return _stratum;
        }
        
        @Override
        public Uint8 getVersion() {
            return _version;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
