package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpAuthKeysTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.NtpKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.NtpKeyKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for list of NTP authentication keys
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container ntp-keys {
 *   list ntp-key {
 *     key key-id;
 *     leaf key-id {
 *       type leafref {
 *         path ../config/key-id;
 *       }
 *     }
 *     container config {
 *       uses system-ntp-auth-keys-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-ntp-auth-keys-config;
 *       uses system-ntp-auth-keys-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link NtpKeysBuilder}.
 * @see NtpKeysBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NtpKeys
    extends
    ChildOf<SystemNtpAuthKeysTop>,
    Augmentable<NtpKeys>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ntp-keys");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.NtpKeys> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.NtpKeys.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.@NonNull NtpKeys obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getNtpKey());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.@NonNull NtpKeys thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.NtpKeys other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.NtpKeys.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getNtpKey(), other.getNtpKey())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.@NonNull NtpKeys obj) {
        final var helper = MoreObjects.toStringHelper("NtpKeys");
        CodeHelpers.appendValue(helper, "ntpKey", obj.getNtpKey());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return ntpKey, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of NTP authentication keys
     *     </code>
     * </pre>
     *
     * @return {@code Map<NtpKeyKey, NtpKey>} ntpKey, or {@code null} if it is not present.
     *
     */
    @Nullable Map<NtpKeyKey, NtpKey> getNtpKey();
    
    /**
     * Return ntpKey, or an empty list if it is not present.
     *
     * @return {@code Map<NtpKeyKey, NtpKey>} ntpKey, or an empty list if it is not present.
     *
     */
    default @NonNull Map<NtpKeyKey, NtpKey> nonnullNtpKey() {
        return CodeHelpers.nonnull(getNtpKey());
    }

}

