package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.Cpu;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.CpuKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for the list of CPU cores on the system
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container cpus {
 *   config false;
 *   list cpu {
 *     key index;
 *     leaf index {
 *       type leafref {
 *         path ../state/index;
 *       }
 *     }
 *     container state {
 *       uses system-cpu-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link CpusBuilder}.
 * @see CpusBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Cpus
    extends
    ChildOf<SystemCpuTop>,
    Augmentable<Cpus>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("cpus");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.Cpus> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.Cpus.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.@NonNull Cpus obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getCpu());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.@NonNull Cpus thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.Cpus other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.Cpus.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getCpu(), other.getCpu())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.@NonNull Cpus obj) {
        final var helper = MoreObjects.toStringHelper("Cpus");
        CodeHelpers.appendValue(helper, "cpu", obj.getCpu());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return cpu, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of CPU cores on the system (including logical CPUs on hyperthreaded
     *         systems), keyed by either a numerical index, or the ALL value for an entry
     *         representing the aggregation across all CPUs.
     *     </code>
     * </pre>
     *
     * @return {@code Map<CpuKey, Cpu>} cpu, or {@code null} if it is not present.
     *
     */
    @Nullable Map<CpuKey, Cpu> getCpu();
    
    /**
     * Return cpu, or an empty list if it is not present.
     *
     * @return {@code Map<CpuKey, Cpu>} cpu, or an empty list if it is not present.
     *
     */
    default @NonNull Map<CpuKey, Cpu> nonnullCpu() {
        return CodeHelpers.nonnull(getCpu());
    }

}

