package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.AvgMinMaxInstantStatsPct;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Percentage of CPU time spent waiting for I/O.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container wait {
 *   uses oc-types:avg-min-max-instant-stats-pct;
 * }
 * </pre>
 * <p>To create instances of this class use {@link WaitBuilder}.
 * @see WaitBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Wait
    extends
    ChildOf<SystemCpuState>,
    Augmentable<Wait>,
    AvgMinMaxInstantStatsPct
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("wait");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.@NonNull Wait obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAvg());
        result = prime * result + Objects.hashCode(obj.getInstant());
        result = prime * result + Objects.hashCode(obj.getInterval());
        result = prime * result + Objects.hashCode(obj.getMax());
        result = prime * result + Objects.hashCode(obj.getMaxTime());
        result = prime * result + Objects.hashCode(obj.getMin());
        result = prime * result + Objects.hashCode(obj.getMinTime());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.@NonNull Wait thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAvg(), other.getAvg())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInstant(), other.getInstant())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInterval(), other.getInterval())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMax(), other.getMax())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxTime(), other.getMaxTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMin(), other.getMin())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMinTime(), other.getMinTime())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.@NonNull Wait obj) {
        final var helper = MoreObjects.toStringHelper("Wait");
        CodeHelpers.appendValue(helper, "avg", obj.getAvg());
        CodeHelpers.appendValue(helper, "instant", obj.getInstant());
        CodeHelpers.appendValue(helper, "interval", obj.getInterval());
        CodeHelpers.appendValue(helper, "max", obj.getMax());
        CodeHelpers.appendValue(helper, "maxTime", obj.getMaxTime());
        CodeHelpers.appendValue(helper, "min", obj.getMin());
        CodeHelpers.appendValue(helper, "minTime", obj.getMinTime());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

