package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SYSLOGFACILITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SyslogSeverity;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.State;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of selectors for log messages
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * list selector {
 *   key "facility severity";
 *   leaf facility {
 *     type leafref {
 *       path ../config/facility;
 *     }
 *   }
 *   leaf severity {
 *     type leafref {
 *       path ../config/severity;
 *     }
 *   }
 *   container config {
 *     uses logging-selectors-config;
 *   }
 *   container state {
 *     config false;
 *     uses logging-selectors-config;
 *     uses logging-selectors-state;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link SelectorBuilder}.
 * @see SelectorBuilder
 * @see SelectorKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Selector
    extends
    ChildOf<Selectors>,
    Augmentable<Selector>,
    Identifiable<SelectorKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("selector");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.Selector> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.Selector.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.@NonNull Selector obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getFacility());
        result = prime * result + Objects.hashCode(obj.getSeverity());
        result = prime * result + Objects.hashCode(obj.getState());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.@NonNull Selector thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.Selector other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.Selector.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getFacility(), other.getFacility())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSeverity(), other.getSeverity())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.@NonNull Selector obj) {
        final var helper = MoreObjects.toStringHelper("Selector");
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "facility", obj.getFacility());
        CodeHelpers.appendValue(helper, "severity", obj.getSeverity());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    SelectorKey key();
    
    /**
     * Return facility, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to facility list key
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends SYSLOGFACILITY>} facility, or {@code null} if it is not present.
     *
     */
    Class<? extends SYSLOGFACILITY> getFacility();
    
    /**
     * Return facility, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to facility list key
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends SYSLOGFACILITY>} facility, guaranteed to be non-null.
     * @throws NoSuchElementException if facility is not present
     *
     */
    default @NonNull Class<? extends SYSLOGFACILITY> requireFacility() {
        return CodeHelpers.require(getFacility(), "facility");
    }
    
    /**
     * Return severity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to severity list key
     *     </code>
     * </pre>
     *
     * @return {@code SyslogSeverity} severity, or {@code null} if it is not present.
     *
     */
    SyslogSeverity getSeverity();
    
    /**
     * Return severity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to severity list key
     *     </code>
     * </pre>
     *
     * @return {@code SyslogSeverity} severity, guaranteed to be non-null.
     * @throws NoSuchElementException if severity is not present
     *
     */
    default @NonNull SyslogSeverity requireSeverity() {
        return CodeHelpers.require(getSeverity(), "severity");
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration data 
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data 
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

