package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.console.top;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingSelectorsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.console.top.console.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.console.top.console.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Console} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Console createConsole(int fooXyzzy, int barBaz) {
 *         return new ConsoleBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Console, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Console
 *
 */
@Generated("mdsal-binding-generator")
public class ConsoleBuilder {

    private Config _config;
    private Selectors _selectors;
    private State _state;


    Map<Class<? extends Augmentation<Console>>, Augmentation<Console>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConsoleBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link LoggingSelectorsTop}.
     *
     * @param arg LoggingSelectorsTop from which the builder should be initialized
     */
    public ConsoleBuilder(LoggingSelectorsTop arg) {
        this._selectors = arg.getSelectors();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Console}.
     *
     * @param base Console from which the builder should be initialized
     */
    public ConsoleBuilder(Console base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._config = base.getConfig();
        this._selectors = base.getSelectors();
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link LoggingSelectorsTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LoggingSelectorsTop) {
            this._selectors = ((LoggingSelectorsTop)arg).getSelectors();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[LoggingSelectorsTop]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Console#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Console#getSelectors()}.
     *
     * @return current value
     */
    public Selectors getSelectors() {
        return _selectors;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Console#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Console>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Console#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConsoleBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Console#getSelectors()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConsoleBuilder setSelectors(final Selectors value) {
        this._selectors = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Console#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConsoleBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConsoleBuilder addAugmentation(Augmentation<Console> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConsoleBuilder removeAugmentation(Class<? extends Augmentation<Console>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Console} instance.
     *
     * @return A new {@link Console} instance.
     */
    public @NonNull Console build() {
        return new ConsoleImpl(this);
    }

    private static final class ConsoleImpl
        extends AbstractAugmentable<Console>
        implements Console {
    
        private final Config _config;
        private final Selectors _selectors;
        private final State _state;
    
        ConsoleImpl(ConsoleBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._selectors = base.getSelectors();
            this._state = base.getState();
        }
    
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Selectors getSelectors() {
            return _selectors;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Console.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Console.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Console.bindingToString(this);
        }
    }
}
