package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.MinMaxTime;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatIntervalState;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common grouping for recording temperature values in Celsius with 1 decimal 
 * precision. Values include the instantaneous, average, minimum, and maximum 
 * statistics
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform-types</b>
 * <pre>
 * grouping avg-min-max-instant-stats-precision1-celsius {
 *   leaf instant {
 *     type decimal64 {
 *       fraction-digits 1;
 *     }
 *     units celsius;
 *   }
 *   leaf avg {
 *     type decimal64 {
 *       fraction-digits 1;
 *     }
 *     units celsius;
 *   }
 *   leaf min {
 *     type decimal64 {
 *       fraction-digits 1;
 *     }
 *     units celsius;
 *   }
 *   leaf max {
 *     type decimal64 {
 *       fraction-digits 1;
 *     }
 *     units celsius;
 *   }
 *   uses oc-types:stat-interval-state;
 *   uses oc-types:min-max-time;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AvgMinMaxInstantStatsPrecision1Celsius
    extends
    DataObject,
    StatIntervalState,
    MinMaxTime
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("avg-min-max-instant-stats-precision1-celsius");

    @Override
    Class<? extends AvgMinMaxInstantStatsPrecision1Celsius> implementedInterface();
    
    /**
     * Return instant, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The instantaneous value of the statistic.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} instant, or {@code null} if it is not present.
     *
     */
    Decimal64 getInstant();
    
    /**
     * Return instant, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The instantaneous value of the statistic.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} instant, guaranteed to be non-null.
     * @throws NoSuchElementException if instant is not present
     *
     */
    default @NonNull Decimal64 requireInstant() {
        return CodeHelpers.require(getInstant(), "instant");
    }
    
    /**
     * Return avg, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The arithmetic mean value of the statistic over the sampling period.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} avg, or {@code null} if it is not present.
     *
     */
    Decimal64 getAvg();
    
    /**
     * Return avg, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The arithmetic mean value of the statistic over the sampling period.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} avg, guaranteed to be non-null.
     * @throws NoSuchElementException if avg is not present
     *
     */
    default @NonNull Decimal64 requireAvg() {
        return CodeHelpers.require(getAvg(), "avg");
    }
    
    /**
     * Return min, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The minimum value of the statistic over the sampling period
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} min, or {@code null} if it is not present.
     *
     */
    Decimal64 getMin();
    
    /**
     * Return min, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The minimum value of the statistic over the sampling period
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} min, guaranteed to be non-null.
     * @throws NoSuchElementException if min is not present
     *
     */
    default @NonNull Decimal64 requireMin() {
        return CodeHelpers.require(getMin(), "min");
    }
    
    /**
     * Return max, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum value of the statistic over the sampling period
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} max, or {@code null} if it is not present.
     *
     */
    Decimal64 getMax();
    
    /**
     * Return max, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum value of the statistic over the sampling period
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} max, guaranteed to be non-null.
     * @throws NoSuchElementException if max is not present
     *
     */
    default @NonNull Decimal64 requireMax() {
        return CodeHelpers.require(getMax(), "max");
    }

}

