package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum FailureMode implements Enumeration {
    /**
     * Packets and messages destined to the controllers are
     * dropped. Flow entries continue to expire according to
     * their timeouts.
     */
    SECURE(0, "SECURE"),
    
    /**
     * Processes all packets using the OFPP_NORMAL reserved
     * port. The switch acts as a legacy Ethernet switch or
     * router.
     */
    STANDALONE(1, "STANDALONE")
    ;

    private static final Map<String, FailureMode> NAME_MAP;
    private static final Map<Integer, FailureMode> VALUE_MAP;

    static {
        final Builder<String, FailureMode> nb = ImmutableMap.builder();
        final Builder<Integer, FailureMode> vb = ImmutableMap.builder();
        for (FailureMode enumItem : FailureMode.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private FailureMode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding FailureMode item, if present
     * @throws NullPointerException if {@code name} is null
     */
    public static Optional<FailureMode> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding FailureMode item, or null if no such item exists
     */
    public static FailureMode forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
