package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowAgentConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.DatapathId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.FailureMode;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Config} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Config createConfig(int fooXyzzy, int barBaz) {
 *         return new ConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Config, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Config
 *
 */
@Generated("mdsal-binding-generator")
public class ConfigBuilder {

    private Uint32 _backoffInterval;
    private DatapathId _datapathId;
    private FailureMode _failureMode;
    private Uint32 _inactivityProbe;
    private Uint32 _maxBackoff;


    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConfigBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link OpenflowAgentConfig}.
     *
     * @param arg OpenflowAgentConfig from which the builder should be initialized
     */
    public ConfigBuilder(OpenflowAgentConfig arg) {
        this._datapathId = arg.getDatapathId();
        this._failureMode = arg.getFailureMode();
        this._backoffInterval = arg.getBackoffInterval();
        this._maxBackoff = arg.getMaxBackoff();
        this._inactivityProbe = arg.getInactivityProbe();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Config}.
     *
     * @param base Config from which the builder should be initialized
     */
    public ConfigBuilder(Config base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._backoffInterval = base.getBackoffInterval();
        this._datapathId = base.getDatapathId();
        this._failureMode = base.getFailureMode();
        this._inactivityProbe = base.getInactivityProbe();
        this._maxBackoff = base.getMaxBackoff();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link OpenflowAgentConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowAgentConfig) {
            this._datapathId = ((OpenflowAgentConfig)arg).getDatapathId();
            this._failureMode = ((OpenflowAgentConfig)arg).getFailureMode();
            this._backoffInterval = ((OpenflowAgentConfig)arg).getBackoffInterval();
            this._maxBackoff = ((OpenflowAgentConfig)arg).getMaxBackoff();
            this._inactivityProbe = ((OpenflowAgentConfig)arg).getInactivityProbe();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[OpenflowAgentConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Config#getBackoffInterval()}.
     *
     * @return current value
     */
    public Uint32 getBackoffInterval() {
        return _backoffInterval;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getDatapathId()}.
     *
     * @return current value
     */
    public DatapathId getDatapathId() {
        return _datapathId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getFailureMode()}.
     *
     * @return current value
     */
    public FailureMode getFailureMode() {
        return _failureMode;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getInactivityProbe()}.
     *
     * @return current value
     */
    public Uint32 getInactivityProbe() {
        return _inactivityProbe;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getMaxBackoff()}.
     *
     * @return current value
     */
    public Uint32 getMaxBackoff() {
        return _maxBackoff;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Config#getBackoffInterval()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setBackoffInterval(final Uint32 value) {
        this._backoffInterval = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getDatapathId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setDatapathId(final DatapathId value) {
        this._datapathId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getFailureMode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setFailureMode(final FailureMode value) {
        this._failureMode = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getInactivityProbe()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setInactivityProbe(final Uint32 value) {
        this._inactivityProbe = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getMaxBackoff()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setMaxBackoff(final Uint32 value) {
        this._maxBackoff = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Config} instance.
     *
     * @return A new {@link Config} instance.
     */
    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
        extends AbstractAugmentable<Config>
        implements Config {
    
        private final Uint32 _backoffInterval;
        private final DatapathId _datapathId;
        private final FailureMode _failureMode;
        private final Uint32 _inactivityProbe;
        private final Uint32 _maxBackoff;
    
        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._backoffInterval = base.getBackoffInterval();
            this._datapathId = base.getDatapathId();
            this._failureMode = base.getFailureMode();
            this._inactivityProbe = base.getInactivityProbe();
            this._maxBackoff = base.getMaxBackoff();
        }
    
        @Override
        public Uint32 getBackoffInterval() {
            return _backoffInterval;
        }
        
        @Override
        public DatapathId getDatapathId() {
            return _datapathId;
        }
        
        @Override
        public FailureMode getFailureMode() {
            return _failureMode;
        }
        
        @Override
        public Uint32 getInactivityProbe() {
            return _inactivityProbe;
        }
        
        @Override
        public Uint32 getMaxBackoff() {
            return _maxBackoff;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Config.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Config.bindingToString(this);
        }
    }
}
