package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.Controllers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level for the Openflow controllers model
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * grouping openflow-controllers-top {
 *   container controllers {
 *     list controller {
 *       key name;
 *       leaf name {
 *         type leafref {
 *           path ../config/name;
 *         }
 *       }
 *       container config {
 *         uses openflow-controller-config;
 *       }
 *       container state {
 *         config false;
 *         uses openflow-controller-config;
 *         uses openflow-controller-state;
 *       }
 *       uses openflow-connections-top;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenflowControllersTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("openflow-controllers-top");

    @Override
    Class<? extends OpenflowControllersTop> implementedInterface();
    
    /**
     * Return controllers, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Container for the Openflow controllers model
     *     </code>
     * </pre>
     *
     * @return {@code Controllers} controllers, or {@code null} if it is not present.
     *
     */
    Controllers getControllers();

}

