package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmState.TypeId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121.OPENCONFIGALARMSEVERITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private String _id;
    private String _resource;
    private Class<? extends OPENCONFIGALARMSEVERITY> _severity;
    private String _text;
    private Timeticks64 _timeCreated;
    private TypeId _typeId;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link AlarmConfig}.
     *
     * @param arg AlarmConfig from which the builder should be initialized
     */
    public StateBuilder(AlarmConfig arg) {
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AlarmState}.
     *
     * @param arg AlarmState from which the builder should be initialized
     */
    public StateBuilder(AlarmState arg) {
        this._id = arg.getId();
        this._resource = arg.getResource();
        this._text = arg.getText();
        this._timeCreated = arg.getTimeCreated();
        this._severity = arg.getSeverity();
        this._typeId = arg.getTypeId();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._id = base.getId();
        this._resource = base.getResource();
        this._severity = base.getSeverity();
        this._text = base.getText();
        this._timeCreated = base.getTimeCreated();
        this._typeId = base.getTypeId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link AlarmState}</li>
     *   <li>{@link AlarmConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AlarmState) {
            this._id = ((AlarmState)arg).getId();
            this._resource = ((AlarmState)arg).getResource();
            this._text = ((AlarmState)arg).getText();
            this._timeCreated = ((AlarmState)arg).getTimeCreated();
            this._severity = ((AlarmState)arg).getSeverity();
            this._typeId = ((AlarmState)arg).getTypeId();
            isValidArg = true;
        }
        if (arg instanceof AlarmConfig) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AlarmState, AlarmConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getId()}.
     *
     * @return current value
     */
    public String getId() {
        return _id;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getResource()}.
     *
     * @return current value
     */
    public String getResource() {
        return _resource;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getSeverity()}.
     *
     * @return current value
     */
    public Class<? extends OPENCONFIGALARMSEVERITY> getSeverity() {
        return _severity;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getText()}.
     *
     * @return current value
     */
    public String getText() {
        return _text;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getTimeCreated()}.
     *
     * @return current value
     */
    public Timeticks64 getTimeCreated() {
        return _timeCreated;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getTypeId()}.
     *
     * @return current value
     */
    public TypeId getTypeId() {
        return _typeId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setId(final String value) {
        this._id = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getResource()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setResource(final String value) {
        this._resource = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getSeverity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setSeverity(final Class<? extends OPENCONFIGALARMSEVERITY> value) {
        this._severity = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getText()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setText(final String value) {
        this._text = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getTimeCreated()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setTimeCreated(final Timeticks64 value) {
        this._timeCreated = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getTypeId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setTypeId(final TypeId value) {
        this._typeId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final String _id;
        private final String _resource;
        private final Class<? extends OPENCONFIGALARMSEVERITY> _severity;
        private final String _text;
        private final Timeticks64 _timeCreated;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmState.TypeId _typeId;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._id = base.getId();
            this._resource = base.getResource();
            this._severity = base.getSeverity();
            this._text = base.getText();
            this._timeCreated = base.getTimeCreated();
            this._typeId = base.getTypeId();
        }
    
        @Override
        public String getId() {
            return _id;
        }
        
        @Override
        public String getResource() {
            return _resource;
        }
        
        @Override
        public Class<? extends OPENCONFIGALARMSEVERITY> getSeverity() {
            return _severity;
        }
        
        @Override
        public String getText() {
            return _text;
        }
        
        @Override
        public Timeticks64 getTimeCreated() {
            return _timeCreated;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmState.TypeId getTypeId() {
            return _typeId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
