package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAccountingTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthorizationTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServergroupCommonTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.aaa.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.aaa.State;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level container for AAA services
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * container aaa {
 *   container config {
 *     uses aaa-config;
 *   }
 *   container state {
 *     config false;
 *     uses aaa-config;
 *     uses aaa-state;
 *   }
 *   uses aaa-authentication-top;
 *   uses aaa-authorization-top;
 *   uses aaa-accounting-top;
 *   uses aaa-servergroup-common-top;
 * }
 * </pre>
 * <p>To create instances of this class use {@link AaaBuilder}.
 * @see AaaBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Aaa
    extends
    ChildOf<AaaTop>,
    Augmentable<Aaa>,
    AaaAuthenticationTop,
    AaaAuthorizationTop,
    AaaAccountingTop,
    AaaServergroupCommonTop
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.Aaa> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.Aaa.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.@NonNull Aaa obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAccounting());
        result = prime * result + Objects.hashCode(obj.getAuthentication());
        result = prime * result + Objects.hashCode(obj.getAuthorization());
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getServerGroups());
        result = prime * result + Objects.hashCode(obj.getState());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.@NonNull Aaa thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.Aaa other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.Aaa.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAccounting(), other.getAccounting())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAuthentication(), other.getAuthentication())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAuthorization(), other.getAuthorization())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getServerGroups(), other.getServerGroups())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.@NonNull Aaa obj) {
        final var helper = MoreObjects.toStringHelper("Aaa");
        CodeHelpers.appendValue(helper, "accounting", obj.getAccounting());
        CodeHelpers.appendValue(helper, "authentication", obj.getAuthentication());
        CodeHelpers.appendValue(helper, "authorization", obj.getAuthorization());
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "serverGroups", obj.getServerGroups());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration data for top level AAA services
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data for top level AAA services 
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

