package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAACCOUNTINGEVENTTYPE;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for AAA accounting events
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-accounting-events-config {
 *   leaf event-type {
 *     type identityref {
 *       base AAA_ACCOUNTING_EVENT_TYPE;
 *     }
 *   }
 *   leaf record {
 *     type enumeration {
 *       enum START_STOP {
 *       }
 *       enum STOP {
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAccountingEventsConfig
    extends
    DataObject
{


    @Generated("mdsal-binding-generator")
    public enum Record implements Enumeration {
        /**
         * Send START record to the accounting server at the
         * beginning of the activity, and STOP record at the
         * end of the activity.
         */
        STARTSTOP(0, "START_STOP"),
        
        /**
         * Send STOP record to the accounting server when the
         * user activity completes
         */
        STOP(1, "STOP")
        ;
    
        private static final Map<String, Record> NAME_MAP;
        private static final Map<Integer, Record> VALUE_MAP;
    
        static {
            final Builder<String, Record> nb = ImmutableMap.builder();
            final Builder<Integer, Record> vb = ImmutableMap.builder();
            for (Record enumItem : Record.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Record(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Record item, if present
         * @throws NullPointerException if {@code name} is null
         */
        public static Optional<Record> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Record item, or null if no such item exists
         */
        public static Record forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-accounting-events-config");

    @Override
    Class<? extends AaaAccountingEventsConfig> implementedInterface();
    
    /**
     * Return eventType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The type of activity to record at the AAA accounting server
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends AAAACCOUNTINGEVENTTYPE>} eventType, or {@code null} if it is not present.
     *
     */
    Class<? extends AAAACCOUNTINGEVENTTYPE> getEventType();
    
    /**
     * Return eventType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The type of activity to record at the AAA accounting server
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends AAAACCOUNTINGEVENTTYPE>} eventType, guaranteed to be non-null.
     * @throws NoSuchElementException if eventType is not present
     *
     */
    default @NonNull Class<? extends AAAACCOUNTINGEVENTTYPE> requireEventType() {
        return CodeHelpers.require(getEventType(), "eventtype");
    }
    
    /**
     * Return record, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Type of record to send to the accounting server for this activity type
     *     </code>
     * </pre>
     *
     * @return {@code Record} record, or {@code null} if it is not present.
     *
     */
    Record getRecord();
    
    /**
     * Return record, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Type of record to send to the accounting server for this activity type
     *     </code>
     * </pre>
     *
     * @return {@code Record} record, guaranteed to be non-null.
     * @throws NoSuchElementException if record is not present
     *
     */
    default @NonNull Record requireRecord() {
        return CodeHelpers.require(getRecord(), "record");
    }

}

