/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemGlobalConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemGlobalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.DomainName;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.DateAndTime;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private Timeticks64 _bootTime;
    private DateAndTime _currentDatetime;
    private DomainName _domainName;
    private DomainName _hostname;
    private String _loginBanner;
    private String _motdBanner;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(SystemGlobalConfig arg) {
        this._hostname = arg.getHostname();
        this._domainName = arg.getDomainName();
        this._loginBanner = arg.getLoginBanner();
        this._motdBanner = arg.getMotdBanner();
    }

    public StateBuilder(SystemGlobalState arg) {
        this._currentDatetime = arg.getCurrentDatetime();
        this._bootTime = arg.getBootTime();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._bootTime = base.getBootTime();
        this._currentDatetime = base.getCurrentDatetime();
        this._domainName = base.getDomainName();
        this._hostname = base.getHostname();
        this._loginBanner = base.getLoginBanner();
        this._motdBanner = base.getMotdBanner();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemGlobalState) {
            this._currentDatetime = ((SystemGlobalState)arg).getCurrentDatetime();
            this._bootTime = ((SystemGlobalState)arg).getBootTime();
            isValidArg = true;
        }
        if (arg instanceof SystemGlobalConfig) {
            this._hostname = ((SystemGlobalConfig)arg).getHostname();
            this._domainName = ((SystemGlobalConfig)arg).getDomainName();
            this._loginBanner = ((SystemGlobalConfig)arg).getLoginBanner();
            this._motdBanner = ((SystemGlobalConfig)arg).getMotdBanner();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemGlobalState, SystemGlobalConfig]");
    }

    public Timeticks64 getBootTime() {
        return this._bootTime;
    }

    public DateAndTime getCurrentDatetime() {
        return this._currentDatetime;
    }

    public DomainName getDomainName() {
        return this._domainName;
    }

    public DomainName getHostname() {
        return this._hostname;
    }

    public String getLoginBanner() {
        return this._loginBanner;
    }

    public String getMotdBanner() {
        return this._motdBanner;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setBootTime(Timeticks64 value) {
        this._bootTime = value;
        return this;
    }

    public StateBuilder setCurrentDatetime(DateAndTime value) {
        this._currentDatetime = value;
        return this;
    }

    public StateBuilder setDomainName(DomainName value) {
        this._domainName = value;
        return this;
    }

    public StateBuilder setHostname(DomainName value) {
        this._hostname = value;
        return this;
    }

    public StateBuilder setLoginBanner(String value) {
        this._loginBanner = value;
        return this;
    }

    public StateBuilder setMotdBanner(String value) {
        this._motdBanner = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Timeticks64 _bootTime;
        private final DateAndTime _currentDatetime;
        private final DomainName _domainName;
        private final DomainName _hostname;
        private final String _loginBanner;
        private final String _motdBanner;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._bootTime = base.getBootTime();
            this._currentDatetime = base.getCurrentDatetime();
            this._domainName = base.getDomainName();
            this._hostname = base.getHostname();
            this._loginBanner = base.getLoginBanner();
            this._motdBanner = base.getMotdBanner();
        }

        @Override
        public Timeticks64 getBootTime() {
            return this._bootTime;
        }

        @Override
        public DateAndTime getCurrentDatetime() {
            return this._currentDatetime;
        }

        @Override
        public DomainName getDomainName() {
            return this._domainName;
        }

        @Override
        public DomainName getHostname() {
            return this._hostname;
        }

        @Override
        public String getLoginBanner() {
            return this._loginBanner;
        }

        @Override
        public String getMotdBanner() {
            return this._motdBanner;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

