/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder {
    private Boolean _enableNtpAuth;
    private Boolean _enabled;
    private IpAddress _ntpSourceAddress;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(SystemNtpConfig arg) {
        this._enabled = arg.getEnabled();
        this._ntpSourceAddress = arg.getNtpSourceAddress();
        this._enableNtpAuth = arg.getEnableNtpAuth();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._enableNtpAuth = base.getEnableNtpAuth();
        this._enabled = base.getEnabled();
        this._ntpSourceAddress = base.getNtpSourceAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpConfig) {
            this._enabled = ((SystemNtpConfig)arg).getEnabled();
            this._ntpSourceAddress = ((SystemNtpConfig)arg).getNtpSourceAddress();
            this._enableNtpAuth = ((SystemNtpConfig)arg).getEnableNtpAuth();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemNtpConfig]");
    }

    public Boolean getEnableNtpAuth() {
        return this._enableNtpAuth;
    }

    public Boolean getEnabled() {
        return this._enabled;
    }

    public IpAddress getNtpSourceAddress() {
        return this._ntpSourceAddress;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setEnableNtpAuth(Boolean value) {
        this._enableNtpAuth = value;
        return this;
    }

    public ConfigBuilder setEnabled(Boolean value) {
        this._enabled = value;
        return this;
    }

    public ConfigBuilder setNtpSourceAddress(IpAddress value) {
        this._ntpSourceAddress = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final Boolean _enableNtpAuth;
        private final Boolean _enabled;
        private final IpAddress _ntpSourceAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._enableNtpAuth = base.getEnableNtpAuth();
            this._enabled = base.getEnabled();
            this._ntpSourceAddress = base.getNtpSourceAddress();
        }

        @Override
        public Boolean getEnableNtpAuth() {
            return this._enableNtpAuth;
        }

        @Override
        public Boolean getEnabled() {
            return this._enabled;
        }

        @Override
        public IpAddress getNtpSourceAddress() {
            return this._ntpSourceAddress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

