/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.Transport;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class StateBuilder {
    private IpAddress _address;
    private AuxiliaryId _auxId;
    private String _certificateId;
    private Boolean _connected;
    private PortNumber _port;
    private Uint8 _priority;
    private String _sourceInterface;
    private Transport _transport;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(OpenflowConnectionsConfig arg) {
        this._auxId = arg.getAuxId();
        this._priority = arg.getPriority();
        this._address = arg.getAddress();
        this._port = arg.getPort();
        this._transport = arg.getTransport();
        this._certificateId = arg.getCertificateId();
        this._sourceInterface = arg.getSourceInterface();
    }

    public StateBuilder(OpenflowConnectionsState arg) {
        this._connected = arg.getConnected();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._address = base.getAddress();
        this._auxId = base.getAuxId();
        this._certificateId = base.getCertificateId();
        this._connected = base.getConnected();
        this._port = base.getPort();
        this._priority = base.getPriority();
        this._sourceInterface = base.getSourceInterface();
        this._transport = base.getTransport();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowConnectionsState) {
            this._connected = ((OpenflowConnectionsState)arg).getConnected();
            isValidArg = true;
        }
        if (arg instanceof OpenflowConnectionsConfig) {
            this._auxId = ((OpenflowConnectionsConfig)arg).getAuxId();
            this._priority = ((OpenflowConnectionsConfig)arg).getPriority();
            this._address = ((OpenflowConnectionsConfig)arg).getAddress();
            this._port = ((OpenflowConnectionsConfig)arg).getPort();
            this._transport = ((OpenflowConnectionsConfig)arg).getTransport();
            this._certificateId = ((OpenflowConnectionsConfig)arg).getCertificateId();
            this._sourceInterface = ((OpenflowConnectionsConfig)arg).getSourceInterface();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[OpenflowConnectionsState, OpenflowConnectionsConfig]");
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public AuxiliaryId getAuxId() {
        return this._auxId;
    }

    public String getCertificateId() {
        return this._certificateId;
    }

    public Boolean getConnected() {
        return this._connected;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Uint8 getPriority() {
        return this._priority;
    }

    public String getSourceInterface() {
        return this._sourceInterface;
    }

    public Transport getTransport() {
        return this._transport;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public StateBuilder setAuxId(AuxiliaryId value) {
        this._auxId = value;
        return this;
    }

    public StateBuilder setCertificateId(String value) {
        this._certificateId = value;
        return this;
    }

    public StateBuilder setConnected(Boolean value) {
        this._connected = value;
        return this;
    }

    public StateBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public StateBuilder setPriority(Uint8 value) {
        this._priority = value;
        return this;
    }

    public StateBuilder setSourceInterface(String value) {
        this._sourceInterface = value;
        return this;
    }

    public StateBuilder setTransport(Transport value) {
        this._transport = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final IpAddress _address;
        private final AuxiliaryId _auxId;
        private final String _certificateId;
        private final Boolean _connected;
        private final PortNumber _port;
        private final Uint8 _priority;
        private final String _sourceInterface;
        private final Transport _transport;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._auxId = base.getAuxId();
            this._certificateId = base.getCertificateId();
            this._connected = base.getConnected();
            this._port = base.getPort();
            this._priority = base.getPriority();
            this._sourceInterface = base.getSourceInterface();
            this._transport = base.getTransport();
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public AuxiliaryId getAuxId() {
            return this._auxId;
        }

        @Override
        public String getCertificateId() {
            return this._certificateId;
        }

        @Override
        public Boolean getConnected() {
            return this._connected;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public Uint8 getPriority() {
            return this._priority;
        }

        @Override
        public String getSourceInterface() {
            return this._sourceInterface;
        }

        @Override
        public Transport getTransport() {
            return this._transport;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

