/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ETHERNETSPEED;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder {
    private Boolean _autoNegotiate;
    private EthernetInterfaceConfig.DuplexMode _duplexMode;
    private Boolean _enableFlowControl;
    private MacAddress _macAddress;
    private Class<? extends ETHERNETSPEED> _portSpeed;
    private Boolean _standaloneLinkTraining;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(EthernetInterfaceConfig arg) {
        this._macAddress = arg.getMacAddress();
        this._autoNegotiate = arg.getAutoNegotiate();
        this._standaloneLinkTraining = arg.getStandaloneLinkTraining();
        this._duplexMode = arg.getDuplexMode();
        this._portSpeed = arg.getPortSpeed();
        this._enableFlowControl = arg.getEnableFlowControl();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._autoNegotiate = base.getAutoNegotiate();
        this._duplexMode = base.getDuplexMode();
        this._enableFlowControl = base.getEnableFlowControl();
        this._macAddress = base.getMacAddress();
        this._portSpeed = base.getPortSpeed();
        this._standaloneLinkTraining = base.getStandaloneLinkTraining();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetInterfaceConfig) {
            this._macAddress = ((EthernetInterfaceConfig)arg).getMacAddress();
            this._autoNegotiate = ((EthernetInterfaceConfig)arg).getAutoNegotiate();
            this._standaloneLinkTraining = ((EthernetInterfaceConfig)arg).getStandaloneLinkTraining();
            this._duplexMode = ((EthernetInterfaceConfig)arg).getDuplexMode();
            this._portSpeed = ((EthernetInterfaceConfig)arg).getPortSpeed();
            this._enableFlowControl = ((EthernetInterfaceConfig)arg).getEnableFlowControl();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[EthernetInterfaceConfig]");
    }

    public Boolean getAutoNegotiate() {
        return this._autoNegotiate;
    }

    public EthernetInterfaceConfig.DuplexMode getDuplexMode() {
        return this._duplexMode;
    }

    public Boolean getEnableFlowControl() {
        return this._enableFlowControl;
    }

    public MacAddress getMacAddress() {
        return this._macAddress;
    }

    public Class<? extends ETHERNETSPEED> getPortSpeed() {
        return this._portSpeed;
    }

    public Boolean getStandaloneLinkTraining() {
        return this._standaloneLinkTraining;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setAutoNegotiate(Boolean value) {
        this._autoNegotiate = value;
        return this;
    }

    public ConfigBuilder setDuplexMode(EthernetInterfaceConfig.DuplexMode value) {
        this._duplexMode = value;
        return this;
    }

    public ConfigBuilder setEnableFlowControl(Boolean value) {
        this._enableFlowControl = value;
        return this;
    }

    public ConfigBuilder setMacAddress(MacAddress value) {
        this._macAddress = value;
        return this;
    }

    public ConfigBuilder setPortSpeed(Class<? extends ETHERNETSPEED> value) {
        this._portSpeed = value;
        return this;
    }

    public ConfigBuilder setStandaloneLinkTraining(Boolean value) {
        this._standaloneLinkTraining = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final Boolean _autoNegotiate;
        private final EthernetInterfaceConfig.DuplexMode _duplexMode;
        private final Boolean _enableFlowControl;
        private final MacAddress _macAddress;
        private final Class<? extends ETHERNETSPEED> _portSpeed;
        private final Boolean _standaloneLinkTraining;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._autoNegotiate = base.getAutoNegotiate();
            this._duplexMode = base.getDuplexMode();
            this._enableFlowControl = base.getEnableFlowControl();
            this._macAddress = base.getMacAddress();
            this._portSpeed = base.getPortSpeed();
            this._standaloneLinkTraining = base.getStandaloneLinkTraining();
        }

        @Override
        public Boolean getAutoNegotiate() {
            return this._autoNegotiate;
        }

        @Override
        public EthernetInterfaceConfig.DuplexMode getDuplexMode() {
            return this._duplexMode;
        }

        @Override
        public Boolean getEnableFlowControl() {
            return this._enableFlowControl;
        }

        @Override
        public MacAddress getMacAddress() {
            return this._macAddress;
        }

        @Override
        public Class<? extends ETHERNETSPEED> getPortSpeed() {
            return this._portSpeed;
        }

        @Override
        public Boolean getStandaloneLinkTraining() {
            return this._standaloneLinkTraining;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

