/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.switched.top.switched.vlan;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanSwitchedConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanSwitchedState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.switched.top.switched.vlan.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanModeType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private VlanId _accessVlan;
    private VlanModeType _interfaceMode;
    private VlanId _nativeVlan;
    private Set<VlanSwitchedConfig.TrunkVlans> _trunkVlans;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(VlanSwitchedConfig arg) {
        this._interfaceMode = arg.getInterfaceMode();
        this._nativeVlan = arg.getNativeVlan();
        this._accessVlan = arg.getAccessVlan();
        this._trunkVlans = arg.getTrunkVlans();
    }

    public StateBuilder(VlanSwitchedState arg) {
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._accessVlan = base.getAccessVlan();
        this._interfaceMode = base.getInterfaceMode();
        this._nativeVlan = base.getNativeVlan();
        this._trunkVlans = base.getTrunkVlans();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanSwitchedState) {
            isValidArg = true;
        }
        if (arg instanceof VlanSwitchedConfig) {
            this._interfaceMode = ((VlanSwitchedConfig)arg).getInterfaceMode();
            this._nativeVlan = ((VlanSwitchedConfig)arg).getNativeVlan();
            this._accessVlan = ((VlanSwitchedConfig)arg).getAccessVlan();
            this._trunkVlans = ((VlanSwitchedConfig)arg).getTrunkVlans();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanSwitchedState, VlanSwitchedConfig]");
    }

    public VlanId getAccessVlan() {
        return this._accessVlan;
    }

    public VlanModeType getInterfaceMode() {
        return this._interfaceMode;
    }

    public VlanId getNativeVlan() {
        return this._nativeVlan;
    }

    public Set<VlanSwitchedConfig.TrunkVlans> getTrunkVlans() {
        return this._trunkVlans;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAccessVlan(VlanId value) {
        this._accessVlan = value;
        return this;
    }

    public StateBuilder setInterfaceMode(VlanModeType value) {
        this._interfaceMode = value;
        return this;
    }

    public StateBuilder setNativeVlan(VlanId value) {
        this._nativeVlan = value;
        return this;
    }

    public StateBuilder setTrunkVlans(Set<VlanSwitchedConfig.TrunkVlans> values) {
        this._trunkVlans = values;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final VlanId _accessVlan;
        private final VlanModeType _interfaceMode;
        private final VlanId _nativeVlan;
        private final Set<VlanSwitchedConfig.TrunkVlans> _trunkVlans;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._accessVlan = base.getAccessVlan();
            this._interfaceMode = base.getInterfaceMode();
            this._nativeVlan = base.getNativeVlan();
            this._trunkVlans = base.getTrunkVlans();
        }

        @Override
        public VlanId getAccessVlan() {
            return this._accessVlan;
        }

        @Override
        public VlanModeType getInterfaceMode() {
            return this._interfaceMode;
        }

        @Override
        public VlanId getNativeVlan() {
            return this._nativeVlan;
        }

        @Override
        public Set<VlanSwitchedConfig.TrunkVlans> getTrunkVlans() {
            return this._trunkVlans;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

