/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingSelectorsConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SYSLOGFACILITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SyslogSeverity;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.Config;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder {
    private Class<? extends SYSLOGFACILITY> _facility;
    private SyslogSeverity _severity;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(LoggingSelectorsConfig arg) {
        this._facility = arg.getFacility();
        this._severity = arg.getSeverity();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._facility = base.getFacility();
        this._severity = base.getSeverity();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LoggingSelectorsConfig) {
            this._facility = ((LoggingSelectorsConfig)arg).getFacility();
            this._severity = ((LoggingSelectorsConfig)arg).getSeverity();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LoggingSelectorsConfig]");
    }

    public Class<? extends SYSLOGFACILITY> getFacility() {
        return this._facility;
    }

    public SyslogSeverity getSeverity() {
        return this._severity;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setFacility(Class<? extends SYSLOGFACILITY> value) {
        this._facility = value;
        return this;
    }

    public ConfigBuilder setSeverity(SyslogSeverity value) {
        this._severity = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final Class<? extends SYSLOGFACILITY> _facility;
        private final SyslogSeverity _severity;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._facility = base.getFacility();
            this._severity = base.getSeverity();
        }

        @Override
        public Class<? extends SYSLOGFACILITY> getFacility() {
            return this._facility;
        }

        @Override
        public SyslogSeverity getSeverity() {
            return this._severity;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

