/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121.OPENCONFIGALARMSEVERITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.MinMaxTime;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatInterval;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatIntervalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentTempAlarmState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.Temperature;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118.AvgMinMaxInstantStatsPrecision1Celsius;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Uint32;

public class TemperatureBuilder {
    private Class<? extends OPENCONFIGALARMSEVERITY> _alarmSeverity;
    private Boolean _alarmStatus;
    private Uint32 _alarmThreshold;
    private Decimal64 _avg;
    private Decimal64 _instant;
    private StatInterval _interval;
    private Decimal64 _max;
    private Timeticks64 _maxTime;
    private Decimal64 _min;
    private Timeticks64 _minTime;
    Map<Class<? extends Augmentation<Temperature>>, Augmentation<Temperature>> augmentation = Map.of();

    public TemperatureBuilder() {
    }

    public TemperatureBuilder(AvgMinMaxInstantStatsPrecision1Celsius arg) {
        this._instant = arg.getInstant();
        this._avg = arg.getAvg();
        this._min = arg.getMin();
        this._max = arg.getMax();
        this._interval = arg.getInterval();
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }

    public TemperatureBuilder(StatIntervalState arg) {
        this._interval = arg.getInterval();
    }

    public TemperatureBuilder(MinMaxTime arg) {
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }

    public TemperatureBuilder(PlatformComponentTempAlarmState arg) {
        this._alarmStatus = arg.getAlarmStatus();
        this._alarmThreshold = arg.getAlarmThreshold();
        this._alarmSeverity = arg.getAlarmSeverity();
    }

    public TemperatureBuilder(Temperature base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Temperature>>, Augmentation<Temperature>>(aug);
        }
        this._alarmSeverity = base.getAlarmSeverity();
        this._alarmStatus = base.getAlarmStatus();
        this._alarmThreshold = base.getAlarmThreshold();
        this._avg = base.getAvg();
        this._instant = base.getInstant();
        this._interval = base.getInterval();
        this._max = base.getMax();
        this._maxTime = base.getMaxTime();
        this._min = base.getMin();
        this._minTime = base.getMinTime();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PlatformComponentTempAlarmState) {
            this._alarmStatus = ((PlatformComponentTempAlarmState)arg).getAlarmStatus();
            this._alarmThreshold = ((PlatformComponentTempAlarmState)arg).getAlarmThreshold();
            this._alarmSeverity = ((PlatformComponentTempAlarmState)arg).getAlarmSeverity();
            isValidArg = true;
        }
        if (arg instanceof AvgMinMaxInstantStatsPrecision1Celsius) {
            this._instant = ((AvgMinMaxInstantStatsPrecision1Celsius)arg).getInstant();
            this._avg = ((AvgMinMaxInstantStatsPrecision1Celsius)arg).getAvg();
            this._min = ((AvgMinMaxInstantStatsPrecision1Celsius)arg).getMin();
            this._max = ((AvgMinMaxInstantStatsPrecision1Celsius)arg).getMax();
            isValidArg = true;
        }
        if (arg instanceof StatIntervalState) {
            this._interval = ((StatIntervalState)arg).getInterval();
            isValidArg = true;
        }
        if (arg instanceof MinMaxTime) {
            this._minTime = ((MinMaxTime)arg).getMinTime();
            this._maxTime = ((MinMaxTime)arg).getMaxTime();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[PlatformComponentTempAlarmState, AvgMinMaxInstantStatsPrecision1Celsius, StatIntervalState, MinMaxTime]");
    }

    public Class<? extends OPENCONFIGALARMSEVERITY> getAlarmSeverity() {
        return this._alarmSeverity;
    }

    public Boolean getAlarmStatus() {
        return this._alarmStatus;
    }

    public Uint32 getAlarmThreshold() {
        return this._alarmThreshold;
    }

    public Decimal64 getAvg() {
        return this._avg;
    }

    public Decimal64 getInstant() {
        return this._instant;
    }

    public StatInterval getInterval() {
        return this._interval;
    }

    public Decimal64 getMax() {
        return this._max;
    }

    public Timeticks64 getMaxTime() {
        return this._maxTime;
    }

    public Decimal64 getMin() {
        return this._min;
    }

    public Timeticks64 getMinTime() {
        return this._minTime;
    }

    public <E$$ extends Augmentation<Temperature>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TemperatureBuilder setAlarmSeverity(Class<? extends OPENCONFIGALARMSEVERITY> value) {
        this._alarmSeverity = value;
        return this;
    }

    public TemperatureBuilder setAlarmStatus(Boolean value) {
        this._alarmStatus = value;
        return this;
    }

    public TemperatureBuilder setAlarmThreshold(Uint32 value) {
        this._alarmThreshold = value;
        return this;
    }

    public TemperatureBuilder setAvg(Decimal64 value) {
        this._avg = value;
        return this;
    }

    public TemperatureBuilder setInstant(Decimal64 value) {
        this._instant = value;
        return this;
    }

    public TemperatureBuilder setInterval(StatInterval value) {
        this._interval = value;
        return this;
    }

    public TemperatureBuilder setMax(Decimal64 value) {
        this._max = value;
        return this;
    }

    public TemperatureBuilder setMaxTime(Timeticks64 value) {
        this._maxTime = value;
        return this;
    }

    public TemperatureBuilder setMin(Decimal64 value) {
        this._min = value;
        return this;
    }

    public TemperatureBuilder setMinTime(Timeticks64 value) {
        this._minTime = value;
        return this;
    }

    public TemperatureBuilder addAugmentation(Augmentation<Temperature> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Temperature>>, Augmentation<Temperature>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TemperatureBuilder removeAugmentation(Class<? extends Augmentation<Temperature>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Temperature build() {
        return new TemperatureImpl(this);
    }

    private static final class TemperatureImpl
    extends AbstractAugmentable<Temperature>
    implements Temperature {
        private final Class<? extends OPENCONFIGALARMSEVERITY> _alarmSeverity;
        private final Boolean _alarmStatus;
        private final Uint32 _alarmThreshold;
        private final Decimal64 _avg;
        private final Decimal64 _instant;
        private final StatInterval _interval;
        private final Decimal64 _max;
        private final Timeticks64 _maxTime;
        private final Decimal64 _min;
        private final Timeticks64 _minTime;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TemperatureImpl(TemperatureBuilder base) {
            super(base.augmentation);
            this._alarmSeverity = base.getAlarmSeverity();
            this._alarmStatus = base.getAlarmStatus();
            this._alarmThreshold = base.getAlarmThreshold();
            this._avg = base.getAvg();
            this._instant = base.getInstant();
            this._interval = base.getInterval();
            this._max = base.getMax();
            this._maxTime = base.getMaxTime();
            this._min = base.getMin();
            this._minTime = base.getMinTime();
        }

        @Override
        public Class<? extends OPENCONFIGALARMSEVERITY> getAlarmSeverity() {
            return this._alarmSeverity;
        }

        @Override
        public Boolean getAlarmStatus() {
            return this._alarmStatus;
        }

        @Override
        public Uint32 getAlarmThreshold() {
            return this._alarmThreshold;
        }

        @Override
        public Decimal64 getAvg() {
            return this._avg;
        }

        @Override
        public Decimal64 getInstant() {
            return this._instant;
        }

        @Override
        public StatInterval getInterval() {
            return this._interval;
        }

        @Override
        public Decimal64 getMax() {
            return this._max;
        }

        @Override
        public Timeticks64 getMaxTime() {
            return this._maxTime;
        }

        @Override
        public Decimal64 getMin() {
            return this._min;
        }

        @Override
        public Timeticks64 getMinTime() {
            return this._minTime;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Temperature.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Temperature.bindingEquals(this, obj);
        }

        public String toString() {
            return Temperature.bindingToString(this);
        }
    }
}

