/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowAgentConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowAgentState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.DatapathId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.FailureMode;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class StateBuilder {
    private Uint32 _backoffInterval;
    private DatapathId _datapathId;
    private FailureMode _failureMode;
    private Uint32 _inactivityProbe;
    private Uint32 _maxBackoff;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(OpenflowAgentConfig arg) {
        this._datapathId = arg.getDatapathId();
        this._failureMode = arg.getFailureMode();
        this._backoffInterval = arg.getBackoffInterval();
        this._maxBackoff = arg.getMaxBackoff();
        this._inactivityProbe = arg.getInactivityProbe();
    }

    public StateBuilder(OpenflowAgentState arg) {
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._backoffInterval = base.getBackoffInterval();
        this._datapathId = base.getDatapathId();
        this._failureMode = base.getFailureMode();
        this._inactivityProbe = base.getInactivityProbe();
        this._maxBackoff = base.getMaxBackoff();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowAgentConfig) {
            this._datapathId = ((OpenflowAgentConfig)arg).getDatapathId();
            this._failureMode = ((OpenflowAgentConfig)arg).getFailureMode();
            this._backoffInterval = ((OpenflowAgentConfig)arg).getBackoffInterval();
            this._maxBackoff = ((OpenflowAgentConfig)arg).getMaxBackoff();
            this._inactivityProbe = ((OpenflowAgentConfig)arg).getInactivityProbe();
            isValidArg = true;
        }
        if (arg instanceof OpenflowAgentState) {
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[OpenflowAgentConfig, OpenflowAgentState]");
    }

    public Uint32 getBackoffInterval() {
        return this._backoffInterval;
    }

    public DatapathId getDatapathId() {
        return this._datapathId;
    }

    public FailureMode getFailureMode() {
        return this._failureMode;
    }

    public Uint32 getInactivityProbe() {
        return this._inactivityProbe;
    }

    public Uint32 getMaxBackoff() {
        return this._maxBackoff;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setBackoffInterval(Uint32 value) {
        this._backoffInterval = value;
        return this;
    }

    public StateBuilder setDatapathId(DatapathId value) {
        this._datapathId = value;
        return this;
    }

    public StateBuilder setFailureMode(FailureMode value) {
        this._failureMode = value;
        return this;
    }

    public StateBuilder setInactivityProbe(Uint32 value) {
        this._inactivityProbe = value;
        return this;
    }

    public StateBuilder setMaxBackoff(Uint32 value) {
        this._maxBackoff = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Uint32 _backoffInterval;
        private final DatapathId _datapathId;
        private final FailureMode _failureMode;
        private final Uint32 _inactivityProbe;
        private final Uint32 _maxBackoff;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._backoffInterval = base.getBackoffInterval();
            this._datapathId = base.getDatapathId();
            this._failureMode = base.getFailureMode();
            this._inactivityProbe = base.getInactivityProbe();
            this._maxBackoff = base.getMaxBackoff();
        }

        @Override
        public Uint32 getBackoffInterval() {
            return this._backoffInterval;
        }

        @Override
        public DatapathId getDatapathId() {
            return this._datapathId;
        }

        @Override
        public FailureMode getFailureMode() {
            return this._failureMode;
        }

        @Override
        public Uint32 getInactivityProbe() {
            return this._inactivityProbe;
        }

        @Override
        public Uint32 getMaxBackoff() {
            return this._maxBackoff;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

