/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.aggregation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationLogicalConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationLogicalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.aggregation.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class StateBuilder {
    private Uint32 _lagSpeed;
    private AggregationType _lagType;
    private Set<String> _member;
    private Uint16 _minLinks;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(AggregationLogicalConfig arg) {
        this._lagType = arg.getLagType();
        this._minLinks = arg.getMinLinks();
    }

    public StateBuilder(AggregationLogicalState arg) {
        this._lagSpeed = arg.getLagSpeed();
        this._member = arg.getMember();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._lagSpeed = base.getLagSpeed();
        this._lagType = base.getLagType();
        this._member = base.getMember();
        this._minLinks = base.getMinLinks();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AggregationLogicalState) {
            this._lagSpeed = ((AggregationLogicalState)arg).getLagSpeed();
            this._member = ((AggregationLogicalState)arg).getMember();
            isValidArg = true;
        }
        if (arg instanceof AggregationLogicalConfig) {
            this._lagType = ((AggregationLogicalConfig)arg).getLagType();
            this._minLinks = ((AggregationLogicalConfig)arg).getMinLinks();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AggregationLogicalState, AggregationLogicalConfig]");
    }

    public Uint32 getLagSpeed() {
        return this._lagSpeed;
    }

    public AggregationType getLagType() {
        return this._lagType;
    }

    public Set<String> getMember() {
        return this._member;
    }

    public Uint16 getMinLinks() {
        return this._minLinks;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setLagSpeed(Uint32 value) {
        this._lagSpeed = value;
        return this;
    }

    public StateBuilder setLagType(AggregationType value) {
        this._lagType = value;
        return this;
    }

    public StateBuilder setMember(Set<String> values) {
        this._member = values;
        return this;
    }

    public StateBuilder setMinLinks(Uint16 value) {
        this._minLinks = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Uint32 _lagSpeed;
        private final AggregationType _lagType;
        private final Set<String> _member;
        private final Uint16 _minLinks;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._lagSpeed = base.getLagSpeed();
            this._lagType = base.getLagType();
            this._member = base.getMember();
            this._minLinks = base.getMinLinks();
        }

        @Override
        public Uint32 getLagSpeed() {
            return this._lagSpeed;
        }

        @Override
        public AggregationType getLagType() {
            return this._lagType;
        }

        @Override
        public Set<String> getMember() {
            return this._member;
        }

        @Override
        public Uint16 getMinLinks() {
            return this._minLinks;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

