package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum VlanModeType implements Enumeration {
    /**
     * Access mode VLAN interface (No 802.1q header)
     */
    ACCESS(0, "ACCESS"),
    
    /**
     * Trunk mode VLAN interface
     */
    TRUNK(1, "TRUNK")
    ;

    private static final Map<String, VlanModeType> NAME_MAP;
    private static final Map<Integer, VlanModeType> VALUE_MAP;

    static {
        final Builder<String, VlanModeType> nb = ImmutableMap.builder();
        final Builder<Integer, VlanModeType> vb = ImmutableMap.builder();
        for (VlanModeType enumItem : VlanModeType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private VlanModeType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding VlanModeType item, if present
     * @throws NullPointerException if {@code name} is null
     */
    public static Optional<VlanModeType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding VlanModeType item, or null if no such item exists
     */
    public static VlanModeType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
