package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.Vlan;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.VlanKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Container for VLAN configuration and state variables
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * container vlans {
 *   list vlan {
 *     key vlan-id;
 *     leaf vlan-id {
 *       type leafref {
 *         path ../config/vlan-id;
 *       }
 *     }
 *     container config {
 *       uses vlan-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-config;
 *       uses vlan-state;
 *     }
 *     uses vlan-members-state;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link VlansBuilder}.
 * @see VlansBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Vlans
    extends
    ChildOf<VlanTop>,
    Augmentable<Vlans>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlans");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.Vlans> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.Vlans.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.@NonNull Vlans obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getVlan());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.@NonNull Vlans thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.Vlans other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.Vlans.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getVlan(), other.getVlan())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.@NonNull Vlans obj) {
        final var helper = MoreObjects.toStringHelper("Vlans");
        CodeHelpers.appendValue(helper, "vlan", obj.getVlan());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return vlan, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configured VLANs keyed by id
     *     </code>
     * </pre>
     *
     * @return {@code Map<VlanKey, Vlan>} vlan, or {@code null} if it is not present.
     *
     */
    @Nullable Map<VlanKey, Vlan> getVlan();
    
    /**
     * Return vlan, or an empty list if it is not present.
     *
     * @return {@code Map<VlanKey, Vlan>} vlan, or an empty list if it is not present.
     *
     */
    default @NonNull Map<VlanKey, Vlan> nonnullVlan() {
        return CodeHelpers.nonnull(getVlan());
    }

}

