package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.single.tagged.range;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalSingleTaggedRangeConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private VlanId _highVlanId;
    private VlanId _lowVlanId;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link VlanLogicalSingleTaggedRangeConfig}.
     *
     * @param arg VlanLogicalSingleTaggedRangeConfig from which the builder should be initialized
     */
    public StateBuilder(VlanLogicalSingleTaggedRangeConfig arg) {
        this._lowVlanId = arg.getLowVlanId();
        this._highVlanId = arg.getHighVlanId();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._highVlanId = base.getHighVlanId();
        this._lowVlanId = base.getLowVlanId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link VlanLogicalSingleTaggedRangeConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanLogicalSingleTaggedRangeConfig) {
            this._lowVlanId = ((VlanLogicalSingleTaggedRangeConfig)arg).getLowVlanId();
            this._highVlanId = ((VlanLogicalSingleTaggedRangeConfig)arg).getHighVlanId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VlanLogicalSingleTaggedRangeConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getHighVlanId()}.
     *
     * @return current value
     */
    public VlanId getHighVlanId() {
        return _highVlanId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getLowVlanId()}.
     *
     * @return current value
     */
    public VlanId getLowVlanId() {
        return _lowVlanId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getHighVlanId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setHighVlanId(final VlanId value) {
        this._highVlanId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getLowVlanId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLowVlanId(final VlanId value) {
        this._lowVlanId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final VlanId _highVlanId;
        private final VlanId _lowVlanId;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._highVlanId = base.getHighVlanId();
            this._lowVlanId = base.getLowVlanId();
        }
    
        @Override
        public VlanId getHighVlanId() {
            return _highVlanId;
        }
        
        @Override
        public VlanId getLowVlanId() {
            return _lowVlanId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
