package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.TPIDTYPES;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State1 createState1(int fooXyzzy, int barBaz) {
 *         return new State1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State1
 *
 */
@Generated("mdsal-binding-generator")
public class State1Builder {

    private Class<? extends TPIDTYPES> _tpid;



    /**
     * Construct an empty builder.
     */
    public State1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link VlanTpidConfig}.
     *
     * @param arg VlanTpidConfig from which the builder should be initialized
     */
    public State1Builder(VlanTpidConfig arg) {
        this._tpid = arg.getTpid();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link VlanTpidState}.
     *
     * @param arg VlanTpidState from which the builder should be initialized
     */
    public State1Builder(VlanTpidState arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State1}.
     *
     * @param base State1 from which the builder should be initialized
     */
    public State1Builder(State1 base) {
        this._tpid = base.getTpid();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link VlanTpidConfig}</li>
     *   <li>{@link VlanTpidState}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanTpidConfig) {
            this._tpid = ((VlanTpidConfig)arg).getTpid();
            isValidArg = true;
        }
        if (arg instanceof VlanTpidState) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VlanTpidConfig, VlanTpidState]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State1#getTpid()}.
     *
     * @return current value
     */
    public Class<? extends TPIDTYPES> getTpid() {
        return _tpid;
    }

    
    /**
     * Set the property corresponding to {@link State1#getTpid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public State1Builder setTpid(final Class<? extends TPIDTYPES> value) {
        this._tpid = value;
        return this;
    }
    

    /**
     * A new {@link State1} instance.
     *
     * @return A new {@link State1} instance.
     */
    public @NonNull State1 build() {
        return new State1Impl(this);
    }

    private static final class State1Impl
        implements State1 {
    
        private final Class<? extends TPIDTYPES> _tpid;
    
        State1Impl(State1Builder base) {
            this._tpid = base.getTpid();
        }
    
        @Override
        public Class<? extends TPIDTYPES> getTpid() {
            return _tpid;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State1.bindingToString(this);
        }
    }
}
