package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.routed.top.RoutedVlan;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Interface1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Interface1 createInterface1(int fooXyzzy, int barBaz) {
 *         return new Interface1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Interface1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Interface1
 *
 */
@Generated("mdsal-binding-generator")
public class Interface1Builder {

    private RoutedVlan _routedVlan;



    /**
     * Construct an empty builder.
     */
    public Interface1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link VlanRoutedTop}.
     *
     * @param arg VlanRoutedTop from which the builder should be initialized
     */
    public Interface1Builder(VlanRoutedTop arg) {
        this._routedVlan = arg.getRoutedVlan();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Interface1}.
     *
     * @param base Interface1 from which the builder should be initialized
     */
    public Interface1Builder(Interface1 base) {
        this._routedVlan = base.getRoutedVlan();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link VlanRoutedTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanRoutedTop) {
            this._routedVlan = ((VlanRoutedTop)arg).getRoutedVlan();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VlanRoutedTop]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Interface1#getRoutedVlan()}.
     *
     * @return current value
     */
    public RoutedVlan getRoutedVlan() {
        return _routedVlan;
    }

    
    /**
     * Set the property corresponding to {@link Interface1#getRoutedVlan()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Interface1Builder setRoutedVlan(final RoutedVlan value) {
        this._routedVlan = value;
        return this;
    }
    

    /**
     * A new {@link Interface1} instance.
     *
     * @return A new {@link Interface1} instance.
     */
    public @NonNull Interface1 build() {
        return new Interface1Impl(this);
    }

    private static final class Interface1Impl
        implements Interface1 {
    
        private final RoutedVlan _routedVlan;
    
        Interface1Impl(Interface1Builder base) {
            this._routedVlan = base.getRoutedVlan();
        }
    
        @Override
        public RoutedVlan getRoutedVlan() {
            return _routedVlan;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Interface1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Interface1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Interface1.bindingToString(this);
        }
    }
}
