package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.switched.top.SwitchedVlan;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Ethernet1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Ethernet1 createEthernet1(int fooXyzzy, int barBaz) {
 *         return new Ethernet1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Ethernet1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Ethernet1
 *
 */
@Generated("mdsal-binding-generator")
public class Ethernet1Builder {

    private SwitchedVlan _switchedVlan;



    /**
     * Construct an empty builder.
     */
    public Ethernet1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link VlanSwitchedTop}.
     *
     * @param arg VlanSwitchedTop from which the builder should be initialized
     */
    public Ethernet1Builder(VlanSwitchedTop arg) {
        this._switchedVlan = arg.getSwitchedVlan();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Ethernet1}.
     *
     * @param base Ethernet1 from which the builder should be initialized
     */
    public Ethernet1Builder(Ethernet1 base) {
        this._switchedVlan = base.getSwitchedVlan();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link VlanSwitchedTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanSwitchedTop) {
            this._switchedVlan = ((VlanSwitchedTop)arg).getSwitchedVlan();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VlanSwitchedTop]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Ethernet1#getSwitchedVlan()}.
     *
     * @return current value
     */
    public SwitchedVlan getSwitchedVlan() {
        return _switchedVlan;
    }

    
    /**
     * Set the property corresponding to {@link Ethernet1#getSwitchedVlan()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Ethernet1Builder setSwitchedVlan(final SwitchedVlan value) {
        this._switchedVlan = value;
        return this;
    }
    

    /**
     * A new {@link Ethernet1} instance.
     *
     * @return A new {@link Ethernet1} instance.
     */
    public @NonNull Ethernet1 build() {
        return new Ethernet1Impl(this);
    }

    private static final class Ethernet1Impl
        implements Ethernet1 {
    
        private final SwitchedVlan _switchedVlan;
    
        Ethernet1Impl(Ethernet1Builder base) {
            this._switchedVlan = base.getSwitchedVlan();
        }
    
        @Override
        public SwitchedVlan getSwitchedVlan() {
            return _switchedVlan;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Ethernet1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Ethernet1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Ethernet1.bindingToString(this);
        }
    }
}
