package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.HostEntry;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.HostEntryKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for list of static host entries
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container host-entries {
 *   list host-entry {
 *     key hostname;
 *     leaf hostname {
 *       type leafref {
 *         path ../config/hostname;
 *       }
 *     }
 *     container config {
 *       uses system-dns-static-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-dns-static-config;
 *       uses system-dns-static-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link HostEntriesBuilder}.
 * @see HostEntriesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface HostEntries
    extends
    ChildOf<SystemDnsStaticTop>,
    Augmentable<HostEntries>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("host-entries");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.HostEntries> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.HostEntries.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.@NonNull HostEntries obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getHostEntry());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.@NonNull HostEntries thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.HostEntries other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.HostEntries.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getHostEntry(), other.getHostEntry())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.@NonNull HostEntries obj) {
        final var helper = MoreObjects.toStringHelper("HostEntries");
        CodeHelpers.appendValue(helper, "hostEntry", obj.getHostEntry());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return hostEntry, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of static host entries
     *     </code>
     * </pre>
     *
     * @return {@code Map<HostEntryKey, HostEntry>} hostEntry, or {@code null} if it is not present.
     *
     */
    @Nullable Map<HostEntryKey, HostEntry> getHostEntry();
    
    /**
     * Return hostEntry, or an empty list if it is not present.
     *
     * @return {@code Map<HostEntryKey, HostEntry>} hostEntry, or an empty list if it is not present.
     *
     */
    default @NonNull Map<HostEntryKey, HostEntry> nonnullHostEntry() {
        return CodeHelpers.nonnull(getHostEntry());
    }

}

