package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.Cpus;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for system CPU data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-cpu-top {
 *   container cpus {
 *     config false;
 *     list cpu {
 *       key index;
 *       leaf index {
 *         type leafref {
 *           path ../state/index;
 *         }
 *       }
 *       container state {
 *         uses system-cpu-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemCpuTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-cpu-top");

    @Override
    Class<? extends SystemCpuTop> implementedInterface();
    
    /**
     * Return cpus, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for the list of CPU cores on the system
     *     </code>
     * </pre>
     *
     * @return {@code Cpus} cpus, or {@code null} if it is not present.
     *
     */
    Cpus getCpus();

}

